/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.Filters.FourierTransform;
import Catalano.Math.ComplexNumber;

public class FrequencyFilter {
    private IntRange freq = new IntRange(0, 1024);

    public FrequencyFilter() {
    }

    public FrequencyFilter(int min, int max) {
        this.freq = new IntRange(min, max);
    }

    public FrequencyFilter(IntRange range) {
        this.freq = range;
    }

    public IntRange getFrequencyRange() {
        return this.freq;
    }

    public void setFrequencyRange(IntRange freq) {
        this.freq = freq;
    }

    public void ApplyInPlace(FourierTransform fourierTransform) {
        if (!fourierTransform.isFourierTransformed()) {
            try {
                throw new Exception("the image should be fourier transformed.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int width = fourierTransform.getWidth();
        int height = fourierTransform.getHeight();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int min = this.freq.getMin();
        int max = this.freq.getMax();
        ComplexNumber[][] c = fourierTransform.getData();
        for (int i = 0; i < height; ++i) {
            int y = i - halfHeight;
            for (int j = 0; j < width; ++j) {
                int x = j - halfWidth;
                int d = (int)Math.sqrt(x * x + y * y);
                if (d <= max && d >= min) continue;
                c[i][j].real = 0.0;
                c[i][j].imaginary = 0.0;
            }
        }
    }
}

