/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ColorConverter;

public class ExtractYCbCrChannel
implements IApplyInPlace {
    private Channel YCbCr;

    public ExtractYCbCrChannel(Channel rgb) {
        this.YCbCr = rgb;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            try {
                throw new Exception("Extract Channel works only with RGB images");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            FastBitmap l = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
            switch (this.YCbCr) {
                case Y: {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int r = fastBitmap.getRed(x, y);
                            int g = fastBitmap.getGreen(x, y);
                            int b = fastBitmap.getBlue(x, y);
                            double[] ycbcr = ColorConverter.RGBtoYCbCr(r, g, b, ColorConverter.YCbCrColorSpace.ITU_BT_601);
                            l.setGray(x, y, (int)(ycbcr[0] * 255.0));
                        }
                    }
                    break;
                }
                case Cb: {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int r = fastBitmap.getRed(x, y);
                            int g = fastBitmap.getGreen(x, y);
                            int b = fastBitmap.getBlue(x, y);
                            double[] ycbcr = ColorConverter.RGBtoYCbCr(r, g, b, ColorConverter.YCbCrColorSpace.ITU_BT_601);
                            l.setGray(x, y, (int)((0.5 + ycbcr[1]) * 255.0));
                        }
                    }
                    break;
                }
                case Cr: {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            int r = fastBitmap.getRed(x, y);
                            int g = fastBitmap.getGreen(x, y);
                            int b = fastBitmap.getBlue(x, y);
                            double[] ycbcr = ColorConverter.RGBtoYCbCr(r, g, b, ColorConverter.YCbCrColorSpace.ITU_BT_601);
                            l.setGray(x, y, (int)((0.5 + ycbcr[2]) * 255.0));
                        }
                    }
                    break;
                }
            }
            fastBitmap.setImage(l);
        }
    }

    public static enum Channel {
        Y,
        Cb,
        Cr;

    }
}

