/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IExtract;

public class ExtractRGBChannel
implements IExtract {
    private FastBitmap l;
    private Channel rgb;

    public ExtractRGBChannel(Channel rgb) {
        this.rgb = rgb;
    }

    public Channel getRGB() {
        return this.rgb;
    }

    public void setRGB(Channel rgb) {
        this.rgb = rgb;
    }

    @Override
    public FastBitmap Extract(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            try {
                throw new Exception("Extract Channel works only with RGB images");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            this.l = new FastBitmap(width, height, FastBitmap.ColorSpace.Grayscale);
            switch (this.rgb) {
                case R: {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            this.l.setGray(x, y, fastBitmap.getRed(x, y));
                        }
                    }
                    break;
                }
                case G: {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            this.l.setGray(x, y, fastBitmap.getGreen(x, y));
                        }
                    }
                    break;
                }
                case B: {
                    for (int x = 0; x < height; ++x) {
                        for (int y = 0; y < width; ++y) {
                            this.l.setGray(x, y, fastBitmap.getBlue(x, y));
                        }
                    }
                    break;
                }
            }
        }
        return this.l;
    }

    public static enum Channel {
        R,
        G,
        B;

    }
}

