/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Math.Approximation;

public class Exp
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int i;
        Object[] pixels;
        double scale = 255.0 / Math.log(255.0);
        if (fastBitmap.isGrayscale()) {
            pixels = fastBitmap.getGrayData();
            for (i = 0; i < pixels.length; ++i) {
                double v = pixels[i] & 0xFF;
                if ((v = Approximation.Highprecision_Exp(v / scale)) < 0.0) {
                    v = 0.0;
                }
                if (v > 255.0) {
                    v = 255.0;
                }
                pixels[i] = (byte)v;
            }
        }
        if (fastBitmap.isRGB()) {
            pixels = fastBitmap.getRGBData();
            for (i = 0; i < pixels.length; ++i) {
                double r = pixels[i] >> 16 & 0xFF;
                double g = pixels[i] >> 8 & 0xFF;
                double b = pixels[i] & 0xFF;
                r = Approximation.Highprecision_Exp(r / scale);
                g = Approximation.Highprecision_Exp(g / scale);
                b = Approximation.Highprecision_Exp(b / scale);
                if (r < 0.0) {
                    r = 0.0;
                }
                if (r > 255.0) {
                    r = 255.0;
                }
                if (g < 0.0) {
                    g = 0.0;
                }
                if (g > 255.0) {
                    g = 255.0;
                }
                if (b < 0.0) {
                    b = 0.0;
                }
                if (b > 255.0) {
                    b = 255.0;
                }
                pixels[i] = (int)r << 16 | (int)g << 8 | (int)b;
            }
        }
    }
}

