/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Difference
implements IApplyInPlace {
    private FastBitmap overlayImage;

    public Difference() {
    }

    public Difference(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    public void setOverlayImage(FastBitmap overlayImage) {
        this.overlayImage = overlayImage;
    }

    @Override
    public void applyInPlace(FastBitmap sourceImage) {
        block6: {
            int sizeDestination;
            int sizeOrigin;
            int height;
            int width;
            block5: {
                width = sourceImage.getWidth();
                height = sourceImage.getHeight();
                sizeOrigin = width * height;
                sizeDestination = this.overlayImage.getWidth() * this.overlayImage.getHeight();
                if (!sourceImage.isGrayscale() || !this.overlayImage.isGrayscale()) break block5;
                if (sizeOrigin != sizeDestination) break block6;
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int l = sourceImage.getGray(x, y) - this.overlayImage.getGray(x, y);
                        l = l < 0 ? -l : l;
                        sourceImage.setGray(x, y, l);
                    }
                }
                break block6;
            }
            if (sourceImage.isRGB() && this.overlayImage.isRGB() && sizeOrigin == sizeDestination) {
                for (int x = 0; x < height; ++x) {
                    for (int y = 0; y < width; ++y) {
                        int r = sourceImage.getRed(x, y) - this.overlayImage.getRed(x, y);
                        int g = sourceImage.getGreen(x, y) - this.overlayImage.getGreen(x, y);
                        int b = sourceImage.getBlue(x, y) - this.overlayImage.getBlue(x, y);
                        r = r < 0 ? -r : r;
                        g = g < 0 ? -g : g;
                        b = b < 0 ? -b : b;
                        sourceImage.setRGB(x, y, r, g, b);
                    }
                }
            }
        }
    }
}

