/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Desaturation
implements IApplyInPlace {
    private double saturationFactor = 0.2;

    public double getSaturationFactor() {
        return this.saturationFactor;
    }

    public void setSaturationFactor(double saturationFactor) {
        this.saturationFactor = Math.min(1.0, Math.max(0.0, saturationFactor));
    }

    public Desaturation() {
    }

    public Desaturation(double saturationFactor) {
        this.setSaturationFactor(saturationFactor);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int size = fastBitmap.getSize();
            for (int i = 0; i < size; ++i) {
                double r = fastBitmap.getRed(i);
                double g = fastBitmap.getGreen(i);
                double b = fastBitmap.getBlue(i);
                double luminance = 0.2125 * r + 0.7154 * g + 0.0721 * b;
                double nr = luminance + this.saturationFactor * (r - luminance);
                double ng = luminance + this.saturationFactor * (g - luminance);
                double nb = luminance + this.saturationFactor * (b - luminance);
                fastBitmap.setRGB(i, (int)nr, (int)ng, (int)nb);
            }
        } else {
            throw new IllegalArgumentException("Desaturation only works in RGB space color.");
        }
    }
}

