/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Convolution
implements IApplyInPlace {
    private int width;
    private int height;
    private int[][] kernel;
    private int division;
    private boolean useDiv = false;
    private boolean replicate = false;

    public int[][] getKernel() {
        return this.kernel;
    }

    public void setKernel(int[][] kernel) {
        this.kernel = kernel;
    }

    public void setDivision(int division) {
        this.division = division;
        this.useDiv = true;
    }

    public boolean isReplicate() {
        return this.replicate;
    }

    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public Convolution() {
    }

    public Convolution(int[][] kernel) {
        this.kernel = kernel;
    }

    public Convolution(int[][] kernel, boolean replicate) {
        this.kernel = kernel;
        this.replicate = replicate;
    }

    public Convolution(int[][] kernel, int division) {
        this.kernel = kernel;
        this.division = division;
        this.useDiv = true;
    }

    public Convolution(int[][] kernel, int division, boolean replicate) {
        this.kernel = kernel;
        this.division = division;
        this.replicate = replicate;
        this.useDiv = true;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.width = fastBitmap.getWidth();
        this.height = fastBitmap.getHeight();
        int lines = this.CalcLines(this.kernel);
        FastBitmap copy = new FastBitmap(fastBitmap);
        if (fastBitmap.isGrayscale()) {
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    int div = 0;
                    int gray = 0;
                    for (int i = 0; i < this.kernel.length; ++i) {
                        int Xline = x + (i - lines);
                        for (int j = 0; j < this.kernel[0].length; ++j) {
                            int Yline = y + (j - lines);
                            if (Xline >= 0 && Xline < this.height && Yline >= 0 && Yline < this.width) {
                                gray += this.kernel[i][j] * copy.getGray(Xline, Yline);
                                div += this.kernel[i][j];
                                continue;
                            }
                            if (!this.replicate) continue;
                            int r = x + i - lines;
                            int c = y + j - lines;
                            if (r < 0) {
                                r = 0;
                            }
                            if (r >= this.height) {
                                r = this.height - 1;
                            }
                            if (c < 0) {
                                c = 0;
                            }
                            if (c >= this.width) {
                                c = this.width - 1;
                            }
                            gray += this.kernel[i][j] * copy.getGray(r, c);
                            div += this.kernel[i][j];
                        }
                    }
                    if (div != 0) {
                        gray = this.useDiv ? (gray /= this.division) : (gray /= div);
                    }
                    gray = gray > 255 ? 255 : gray;
                    gray = gray < 0 ? 0 : gray;
                    fastBitmap.setGray(x, y, gray);
                }
            }
        } else {
            for (int x = 0; x < this.height; ++x) {
                for (int y = 0; y < this.width; ++y) {
                    int div = 0;
                    int b = 0;
                    int g = 0;
                    int r = 0;
                    for (int i = 0; i < this.kernel.length; ++i) {
                        int Xline = x + (i - lines);
                        for (int j = 0; j < this.kernel[0].length; ++j) {
                            int Yline = y + (j - lines);
                            if (Xline >= 0 && Xline < this.height && Yline >= 0 && Yline < this.width) {
                                r += this.kernel[i][j] * copy.getRed(Xline, Yline);
                                g += this.kernel[i][j] * copy.getGreen(Xline, Yline);
                                b += this.kernel[i][j] * copy.getBlue(Xline, Yline);
                                div += this.kernel[i][j];
                                continue;
                            }
                            if (!this.replicate) continue;
                            int rr = x + i - lines;
                            int cc = y + j - lines;
                            if (rr < 0) {
                                rr = 0;
                            }
                            if (rr >= this.height) {
                                rr = this.height - 1;
                            }
                            if (cc < 0) {
                                cc = 0;
                            }
                            if (cc >= this.width) {
                                cc = this.width - 1;
                            }
                            r += this.kernel[i][j] * copy.getRed(rr, cc);
                            g += this.kernel[i][j] * copy.getGreen(rr, cc);
                            b += this.kernel[i][j] * copy.getBlue(rr, cc);
                            div += this.kernel[i][j];
                        }
                    }
                    if (div != 0) {
                        if (this.useDiv) {
                            r /= this.division;
                            g /= this.division;
                            b /= this.division;
                        } else {
                            r /= div;
                            g /= div;
                            b /= div;
                        }
                    }
                    r = r > 255 ? 255 : r;
                    g = g > 255 ? 255 : g;
                    b = b > 255 ? 255 : b;
                    r = r < 0 ? 0 : r;
                    g = g < 0 ? 0 : g;
                    b = b < 0 ? 0 : b;
                    fastBitmap.setRGB(x, y, r, g, b);
                }
            }
        }
    }

    private int CalcLines(int[][] kernel) {
        int lines = (kernel[0].length - 1) / 2;
        return lines;
    }
}

