/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.GaussianBlur;
import Catalano.Imaging.Filters.HysteresisThreshold;
import Catalano.Imaging.IApplyInPlace;

public class CannyEdgeDetector
implements IApplyInPlace {
    private double sigma = 1.4;
    private int size = 1;
    private int lowThreshold = 20;
    private int highThreshold = 100;

    public int getLowThreshold() {
        return this.lowThreshold;
    }

    public void setLowThreshold(int lowThreshold) {
        this.lowThreshold = lowThreshold;
    }

    public int getHighThreshold() {
        return this.highThreshold;
    }

    public void setHighThreshold(int highThreshold) {
        this.highThreshold = highThreshold;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public CannyEdgeDetector() {
    }

    public CannyEdgeDetector(int lowThreshold, int highThreshold) {
        this.lowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
    }

    public CannyEdgeDetector(int lowThreshold, int highThreshold, double sigma) {
        this.lowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
        this.sigma = sigma;
    }

    public CannyEdgeDetector(int lowThreshold, int highThreshold, double sigma, int size) {
        this.lowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
        this.sigma = sigma;
        this.size = size;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            int y;
            int x;
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            double toAngle = 57.29577951308232;
            float leftPixel = 0.0f;
            float rightPixel = 0.0f;
            FastBitmap blurredImage = new FastBitmap(fastBitmap);
            GaussianBlur g = new GaussianBlur(this.sigma, this.size);
            g.applyInPlace(blurredImage);
            int[] orients = new int[width * height];
            float[][] gradients = new float[width][height];
            float maxGradient = Float.NEGATIVE_INFINITY;
            int p = 0;
            for (x = 1; x < height - 1; ++x) {
                y = 1;
                while (y < width - 1) {
                    double div;
                    double orientation;
                    int p1 = blurredImage.getGray(x - 1, y + 1);
                    int p2 = blurredImage.getGray(x + 1, y + 1);
                    int p3 = blurredImage.getGray(x - 1, y - 1);
                    int p4 = blurredImage.getGray(x + 1, y - 1);
                    int p5 = blurredImage.getGray(x, y + 1);
                    int p6 = blurredImage.getGray(x, y - 1);
                    int p7 = blurredImage.getGray(x - 1, y);
                    int p8 = blurredImage.getGray(x + 1, y);
                    int gx = p1 + p2 - p3 - p4 + 2 * (p5 - p6);
                    int gy = p3 + p1 - p4 - p2 + 2 * (p7 - p8);
                    gradients[y][x] = (float)Math.sqrt(gx * gx + gy * gy);
                    if (gradients[y][x] > maxGradient) {
                        maxGradient = gradients[y][x];
                    }
                    orientation = gx == 0 ? (gy == 0 ? 0.0 : 90.0) : ((orientation = (div = (double)gy / (double)gx) < 0.0 ? 180.0 - Math.atan(-div) * toAngle : Math.atan(div) * toAngle) < 22.5 ? 0.0 : (orientation < 67.5 ? 45.0 : (orientation < 112.5 ? 90.0 : (orientation < 157.5 ? 135.0 : 0.0))));
                    orients[p] = (int)orientation;
                    ++y;
                    ++p;
                }
            }
            p = 0;
            for (x = 1; x < height - 1; ++x) {
                y = 1;
                while (y < width - 1) {
                    switch (orients[p]) {
                        case 0: {
                            leftPixel = gradients[y - 1][x];
                            rightPixel = gradients[y + 1][x];
                            break;
                        }
                        case 45: {
                            leftPixel = gradients[y - 1][x + 1];
                            rightPixel = gradients[y + 1][x - 1];
                            break;
                        }
                        case 90: {
                            leftPixel = gradients[y][x + 1];
                            rightPixel = gradients[y][x - 1];
                            break;
                        }
                        case 135: {
                            leftPixel = gradients[y + 1][x + 1];
                            rightPixel = gradients[y - 1][x - 1];
                        }
                    }
                    if (gradients[y][x] < leftPixel || gradients[y][x] < rightPixel) {
                        fastBitmap.setGray(x, y, 0);
                    } else {
                        fastBitmap.setGray(x, y, (int)(gradients[y][x] / maxGradient * 255.0f));
                    }
                    ++y;
                    ++p;
                }
            }
        } else {
            throw new IllegalArgumentException("CannyEdgeDetector only works in grayscale images.");
        }
        HysteresisThreshold threshold = new HysteresisThreshold(this.lowThreshold, this.highThreshold);
        threshold.applyInPlace(fastBitmap);
    }
}

