/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Core.IntRange;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.LevelsLinear;
import Catalano.Imaging.IApplyInPlace;

public class BrightnessCorrection
implements IApplyInPlace {
    private LevelsLinear baseFilter = new LevelsLinear();
    private int adjustValue;

    public int getAdjustValue() {
        return this.adjustValue;
    }

    public void setAdjustValue(int adjustValue) {
        this.adjustValue = adjustValue = Math.max(-255, Math.min(255, adjustValue));
        if (adjustValue > 0) {
            this.baseFilter.setInRed(new IntRange(0, 255 - adjustValue));
            this.baseFilter.setInGreen(new IntRange(0, 255 - adjustValue));
            this.baseFilter.setInBlue(new IntRange(0, 255 - adjustValue));
            this.baseFilter.setInGray(new IntRange(0, 255 - adjustValue));
            this.baseFilter.setOutRed(new IntRange(adjustValue, 255));
            this.baseFilter.setOutGreen(new IntRange(adjustValue, 255));
            this.baseFilter.setOutBlue(new IntRange(adjustValue, 255));
            this.baseFilter.setOutGray(new IntRange(adjustValue, 255));
        } else {
            this.baseFilter.setInRed(new IntRange(-adjustValue, 255));
            this.baseFilter.setInGreen(new IntRange(-adjustValue, 255));
            this.baseFilter.setInBlue(new IntRange(-adjustValue, 255));
            this.baseFilter.setInGray(new IntRange(-adjustValue, 255));
            this.baseFilter.setOutRed(new IntRange(0, 255 + adjustValue));
            this.baseFilter.setOutGreen(new IntRange(0, 255 + adjustValue));
            this.baseFilter.setOutBlue(new IntRange(0, 255 + adjustValue));
            this.baseFilter.setOutGray(new IntRange(0, 255 + adjustValue));
        }
    }

    public BrightnessCorrection() {
    }

    public BrightnessCorrection(int adjustValue) {
        this.setAdjustValue(adjustValue);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.baseFilter.applyInPlace(fastBitmap);
    }
}

