/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class BinaryDilatation
implements IApplyInPlace {
    private int[][] kernel;
    private int radius = 0;

    public BinaryDilatation() {
        this.radius = 1;
    }

    public BinaryDilatation(int[][] se) {
        this.kernel = se;
    }

    public BinaryDilatation(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            if (this.radius != 0) {
                this.ApplyInPlace(fastBitmap, this.radius);
            } else {
                this.ApplyInPlace(fastBitmap, this.kernel);
            }
        } else {
            throw new IllegalArgumentException("Binary Dilatation only works in grayscale images.");
        }
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int radius) {
        FastBitmap copy = new FastBitmap(fastBitmap);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int lines = this.CalcLines(radius);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                int l = copy.getGray(x, y);
                if (l != 255) continue;
                for (int i = 0; i < lines; ++i) {
                    int Xline = x + (i - radius);
                    for (int j = 0; j < lines; ++j) {
                        int Yline = y + (j - radius);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width) continue;
                        fastBitmap.setGray(Xline, Yline, 255);
                    }
                }
            }
        }
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int[][] kernel) {
        FastBitmap copy = new FastBitmap(fastBitmap);
        int width = fastBitmap.getWidth();
        int height = fastBitmap.getHeight();
        int lines = this.CalcLines(kernel);
        for (int x = 0; x < height; ++x) {
            for (int y = 0; y < width; ++y) {
                int l = copy.getGray(x, y);
                if (l != 255) continue;
                for (int i = 0; i < kernel.length; ++i) {
                    int Xline = x + (i - lines);
                    for (int j = 0; j < kernel[0].length; ++j) {
                        int Yline = y + (j - lines);
                        if (Xline < 0 || Xline >= height || Yline < 0 || Yline >= width || kernel[i][j] != 1) continue;
                        fastBitmap.setGray(Xline, Yline, 255);
                    }
                }
            }
        }
    }

    private int CalcLines(int[][] se) {
        int lines = (se[0].length - 1) / 2;
        return lines;
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }
}

