/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.BinaryDilatation;
import Catalano.Imaging.Filters.BinaryErosion;
import Catalano.Imaging.IApplyInPlace;

public class BinaryClosing
implements IApplyInPlace {
    private int[][] kernel;
    private int radius = 0;

    public BinaryClosing() {
        this.radius = 1;
    }

    public BinaryClosing(int[][] se) {
        this.kernel = se;
    }

    public BinaryClosing(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            if (this.radius != 0) {
                this.ApplyInPlace(fastBitmap, this.radius);
            } else {
                this.ApplyInPlace(fastBitmap, this.kernel);
            }
        } else {
            throw new IllegalArgumentException("Binary Closing only works in grayscale images.");
        }
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int[][] se) {
        BinaryDilatation dil = new BinaryDilatation(se);
        BinaryErosion ero = new BinaryErosion(se);
        dil.applyInPlace(fastBitmap);
        ero.applyInPlace(fastBitmap);
    }

    private void ApplyInPlace(FastBitmap fastBitmap, int radius) {
        BinaryDilatation dil = new BinaryDilatation(radius);
        BinaryErosion ero = new BinaryErosion(radius);
        dil.applyInPlace(fastBitmap);
        ero.applyInPlace(fastBitmap);
    }
}

