/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Artistic.Blend;
import Catalano.Imaging.Filters.Artistic.Opacity;
import Catalano.Imaging.Filters.Invert;
import Catalano.Imaging.IApplyInPlace;

public class Solarize
implements IApplyInPlace {
    private double p;

    public double getPercentage() {
        return this.p;
    }

    public void setPercentage(double p) {
        this.p = Math.max(0.0, Math.min(1.0, p));
    }

    public Solarize() {
    }

    public Solarize(double percentage) {
        this.setPercentage(percentage);
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap layerA = new FastBitmap(fastBitmap);
        FastBitmap layerB = new FastBitmap(fastBitmap);
        Invert i = new Invert();
        i.applyInPlace(layerA);
        Blend b = new Blend(layerA, Blend.Algorithm.Difference);
        b.applyInPlace(layerB);
        Opacity op = new Opacity(layerB);
        op.setPercentage(this.p);
        op.applyInPlace(fastBitmap);
    }
}

