/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Invert;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.ImageStatistics;

public class HeatMap
implements IApplyInPlace {
    private boolean invert = false;

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public HeatMap() {
    }

    public HeatMap(boolean invert) {
        this.invert = invert;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            fastBitmap.toGrayscale();
        }
        if (this.invert) {
            new Invert().applyInPlace(fastBitmap);
        }
        int size = fastBitmap.getWidth() * fastBitmap.getHeight();
        int min = ImageStatistics.Minimum(fastBitmap);
        int max = ImageStatistics.Maximum(fastBitmap);
        fastBitmap.toRGB();
        for (int i = 0; i < size; ++i) {
            int[] rgb = this.GrayscaleToHeatMap(fastBitmap.getRed(i), min, max);
            fastBitmap.setRGB(i, rgb);
        }
    }

    private int[] GrayscaleToHeatMap(double gray, double min, double max) {
        int r = 0;
        int g = 0;
        int b = 0;
        if ((gray = (gray - min) / (max - min)) <= 0.2) {
            b = (int)(gray / 0.2 * 255.0);
        } else if (gray > 0.2 && gray <= 0.7) {
            b = (int)((1.0 - (gray - 0.2) / 0.5) * 255.0);
        }
        if (gray >= 0.2 && gray <= 0.6) {
            g = (int)((gray - 0.2) / 0.4 * 255.0);
        } else if (gray > 0.6 && gray <= 0.9) {
            g = (int)((1.0 - (gray - 0.6) / 0.3) * 255.0);
        }
        if (gray >= 0.5) {
            r = (int)((gray - 0.5) / 0.5 * 255.0);
        }
        return new int[]{r, g, b};
    }
}

