/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Artistic.Blend;
import Catalano.Imaging.Filters.GaussianNoise;
import Catalano.Imaging.IApplyInPlace;

public class FilmGrain
implements IApplyInPlace {
    private int grain = 127;
    private double stdDev = 8.0;

    public int getGrain() {
        return this.grain;
    }

    public void setGrain(int grain) {
        this.grain = grain;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    public void setStdDev(double stdDev) {
        this.stdDev = stdDev;
    }

    public FilmGrain() {
    }

    public FilmGrain(int grain) {
        this.grain = grain;
    }

    public FilmGrain(int grain, double stdDev) {
        this.grain = grain;
        this.stdDev = stdDev;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (fastBitmap.isRGB()) {
            int width = fastBitmap.getWidth();
            int height = fastBitmap.getHeight();
            FastBitmap layerA = new FastBitmap(width, height, FastBitmap.ColorSpace.RGB);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    layerA.setRGB(i, j, this.grain, this.grain, this.grain);
                }
            }
            GaussianNoise gn = new GaussianNoise(this.stdDev);
            gn.applyInPlace(layerA);
            Blend b = new Blend(layerA, Blend.Algorithm.Overlay);
            b.applyInPlace(fastBitmap);
        }
    }
}

