/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Filters.Artistic;

import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Artistic.Blend;
import Catalano.Imaging.Filters.Artistic.Opacity;
import Catalano.Imaging.Filters.Desaturation;
import Catalano.Imaging.Filters.GaussianBoxBlur;
import Catalano.Imaging.Filters.Invert;
import Catalano.Imaging.IApplyInPlace;

public class FakeHDR
implements IApplyInPlace {
    private double desaturation = 0.0;
    private int sigma = 40;
    private double p = 0.62;

    public double getDesaturation() {
        return this.desaturation;
    }

    public void setDesaturation(double desaturation) {
        this.desaturation = desaturation;
    }

    public int getSigma() {
        return this.sigma;
    }

    public void setSigma(int sigma) {
        this.sigma = sigma;
    }

    public double getPercentage() {
        return this.p;
    }

    public void setPercentage(double p) {
        this.p = Math.max(0.0, Math.min(1.0, p));
    }

    public FakeHDR() {
    }

    public FakeHDR(double percentage) {
        this.setPercentage(percentage);
    }

    public FakeHDR(double desaturation, int sigma, double percentage) {
        this.desaturation = desaturation;
        this.sigma = sigma;
        this.p = percentage;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap layerA = new FastBitmap(fastBitmap);
        FastBitmap layerB = new FastBitmap(fastBitmap);
        Desaturation d = new Desaturation(this.desaturation);
        d.applyInPlace(layerA);
        Invert in = new Invert();
        in.applyInPlace(layerA);
        GaussianBoxBlur fgb = new GaussianBoxBlur(this.sigma);
        fgb.applyInPlace(layerA);
        Blend blend = new Blend(layerB, Blend.Algorithm.Overlay);
        blend.applyInPlace(layerA);
        layerB = new FastBitmap(fastBitmap);
        blend.setAlgorithm(Blend.Algorithm.LinearLight);
        blend.setOverlay(layerA);
        blend.applyInPlace(layerB);
        Opacity o = new Opacity(layerB);
        o.setPercentage(this.p);
        o.applyInPlace(fastBitmap);
    }
}

