/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners;

import Catalano.Core.ArraysUtil;
import Catalano.Core.IntPoint;
import Catalano.Imaging.Corners.ICornersDetector;
import Catalano.Imaging.FastBitmap;
import Catalano.Math.Functions.Gaussian;
import java.util.ArrayList;
import java.util.List;

public class HarrisCornersDetector
implements ICornersDetector {
    HarrisCornerMeasure algo;
    private HarrisCornerMeasure measure = HarrisCornerMeasure.Harris;
    private float k = 0.04f;
    private float threshold = 20000.0f;
    private int suppression = 3;
    private double sigma = 1.2;
    private float[] kernel;
    private int size = 7;

    public HarrisCornerMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(HarrisCornerMeasure measure) {
        this.measure = measure;
    }

    public int getSuppression() {
        return this.suppression;
    }

    public void setSuppression(int suppression) {
        this.suppression = suppression;
    }

    public float getK() {
        return this.k;
    }

    public void setK(float k) {
        this.k = k;
    }

    public float getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float threshold) {
        this.threshold = threshold;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public HarrisCornersDetector() {
        this.init(HarrisCornerMeasure.Harris, this.k, this.threshold, this.sigma, this.suppression, this.size);
    }

    public HarrisCornersDetector(float k) {
        this.init(HarrisCornerMeasure.Harris, k, this.threshold, this.sigma, this.suppression, this.size);
    }

    public HarrisCornersDetector(float k, float threshold) {
        this.init(HarrisCornerMeasure.Harris, k, threshold, this.sigma, this.suppression, this.size);
    }

    public HarrisCornersDetector(float k, float threshold, double sigma) {
        this.init(HarrisCornerMeasure.Harris, k, threshold, sigma, this.suppression, this.size);
    }

    public HarrisCornersDetector(float k, float threshold, double sigma, int suppression) {
        this.init(HarrisCornerMeasure.Harris, k, threshold, sigma, suppression, this.size);
    }

    public HarrisCornersDetector(HarrisCornerMeasure measure, float threshold, double sigma, int suppression) {
        this.init(measure, this.k, threshold, sigma, suppression, this.size);
    }

    public HarrisCornersDetector(HarrisCornerMeasure measure, float threshold, double sigma) {
        this.init(measure, this.k, threshold, sigma, this.suppression, this.size);
    }

    public HarrisCornersDetector(HarrisCornerMeasure measure, float threshold) {
        this.init(measure, this.k, threshold, this.sigma, this.suppression, this.size);
    }

    public HarrisCornersDetector(HarrisCornerMeasure measure) {
        this.init(measure, this.k, this.threshold, this.sigma, this.suppression, this.size);
    }

    private void init(HarrisCornerMeasure measure, float k, float threshold, double sigma, int suppression, int size) {
        this.measure = measure;
        this.threshold = threshold;
        this.k = k;
        this.suppression = suppression;
        this.sigma = sigma;
        this.size = size;
        this.createGaussian();
    }

    private void createGaussian() {
        double[] kernel = new Gaussian(this.sigma).Kernel1D(this.size);
        this.kernel = ArraysUtil.toFloat(kernel);
    }

    @Override
    public List<IntPoint> ProcessImage(FastBitmap fastBitmap) {
        FastBitmap gray;
        if (fastBitmap.isGrayscale()) {
            gray = fastBitmap;
        } else {
            gray = new FastBitmap(fastBitmap);
            gray.toGrayscale();
        }
        int width = gray.getWidth();
        int height = gray.getHeight();
        float[][] diffx = new float[height][width];
        float[][] diffy = new float[height][width];
        float[][] diffxy = new float[height][width];
        for (int i = 1; i < height - 1; ++i) {
            for (int j = 1; j < width - 1; ++j) {
                int p1 = gray.getGray(i - 1, j + 1);
                int p2 = gray.getGray(i, j + 1);
                int p3 = gray.getGray(i + 1, j + 1);
                int p4 = gray.getGray(i - 1, j - 1);
                int p5 = gray.getGray(i, j - 1);
                int p6 = gray.getGray(i + 1, j - 1);
                int p7 = gray.getGray(i + 1, j);
                int p8 = gray.getGray(i - 1, j);
                float h = (float)(p1 + p2 + p3 - (p4 + p5 + p6)) * 0.16666667f;
                float v = (float)(p6 + p7 + p3 - (p4 + p8 + p1)) * 0.16666667f;
                diffx[i][j] = h * h;
                diffy[i][j] = v * v;
                diffxy[i][j] = h * v;
            }
        }
        if (this.sigma > 0.0) {
            float[][] temp = new float[height][width];
            this.convolve(diffx, temp, this.kernel);
            this.convolve(diffy, temp, this.kernel);
            this.convolve(diffxy, temp, this.kernel);
        }
        float[][] map = new float[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                float A = diffx[i][j];
                float B = diffy[i][j];
                float C = diffxy[i][j];
                float M = this.measure == HarrisCornerMeasure.Harris ? A * B - C * C - this.k * ((A + B) * (A + B)) : (A * B - C * C) / (A + B + 1.1920929E-7f);
                if (!(M > this.threshold)) continue;
                map[i][j] = M;
            }
        }
        ArrayList<IntPoint> cornersList = new ArrayList<IntPoint>();
        int maxX = height - this.suppression;
        for (int x = this.suppression; x < maxX; ++x) {
            int maxY = width - this.suppression;
            for (int y = this.suppression; y < maxY; ++y) {
                float currentValue = map[x][y];
                block6: for (int i = -this.suppression; currentValue != 0.0f && i <= this.suppression; ++i) {
                    for (int j = -this.suppression; j <= this.suppression; ++j) {
                        if (!(map[x + i][y + j] > currentValue)) continue;
                        currentValue = 0.0f;
                        continue block6;
                    }
                }
                if (currentValue == 0.0f) continue;
                cornersList.add(new IntPoint(x, y));
            }
        }
        return cornersList;
    }

    private void convolve(float[][] image, float[][] temp, float[] kernel) {
        int k;
        float v;
        int width = image[0].length;
        int height = image.length;
        int radius = kernel.length / 2;
        for (int x = 0; x < height; ++x) {
            for (int y = radius; y < width - radius; ++y) {
                v = 0.0f;
                for (k = 0; k < kernel.length; ++k) {
                    v += image[x][y + k - radius] * kernel[k];
                }
                temp[x][y] = v;
            }
        }
        for (int y = 0; y < width; ++y) {
            for (int x = radius; x < height - radius; ++x) {
                v = 0.0f;
                for (k = 0; k < kernel.length; ++k) {
                    v += temp[x + k - radius][y] * kernel[k];
                }
                image[x][y] = v;
            }
        }
    }

    public static enum HarrisCornerMeasure {
        Harris,
        Noble;

    }
}

