/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Corners.FREAK;

import Catalano.Core.IntPoint;
import Catalano.Imaging.Corners.FREAK.FastRetinaKeypoint;
import Catalano.Imaging.Corners.FREAK.FastRetinaKeypointDescriptor;
import Catalano.Imaging.Corners.FREAK.FastRetinaKeypointPattern;
import Catalano.Imaging.Corners.FeaturePoint;
import Catalano.Imaging.Corners.ICornersDetector;
import Catalano.Imaging.Corners.ICornersFeatureDetector;
import Catalano.Imaging.Corners.SusanCornersDetector;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Tools.IntegralImage;
import java.util.ArrayList;
import java.util.List;

public class FastRetinaKeypointDetector {
    private FastRetinaKeypointDescriptorType featureType = FastRetinaKeypointDescriptorType.Standard;
    private float scale = 22.0f;
    private int octaves = 4;
    private IntegralImage integral;
    private FastBitmap grayImage;
    private FastRetinaKeypointPattern pattern;
    private FastRetinaKeypointDescriptor descriptor;
    public ICornersDetector Detector;
    public ICornersFeatureDetector FDetector;

    public FastRetinaKeypointDescriptor GetDescriptor() {
        if (this.descriptor == null || this.pattern == null) {
            if (this.pattern == null) {
                this.pattern = new FastRetinaKeypointPattern(this.octaves, this.scale);
            }
            this.descriptor = new FastRetinaKeypointDescriptor(this.grayImage, this.integral, this.pattern);
            this.descriptor.setExtended(this.featureType == FastRetinaKeypointDescriptorType.Extended);
        }
        return this.descriptor;
    }

    public FastRetinaKeypointDetector(ICornersDetector cornerDetector) {
        this.Detector = cornerDetector;
    }

    public FastRetinaKeypointDetector(ICornersFeatureDetector cornerFeatureDetector) {
        this.FDetector = cornerFeatureDetector;
    }

    public FastRetinaKeypointDetector() {
        this.Detector = new SusanCornersDetector();
    }

    public List<FastRetinaKeypoint> ProcessImage(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            this.grayImage = new FastBitmap(fastBitmap);
        } else {
            this.grayImage = new FastBitmap(fastBitmap);
            this.grayImage.toGrayscale();
        }
        ArrayList<FastRetinaKeypoint> features = new ArrayList<FastRetinaKeypoint>();
        if (this.Detector != null) {
            List<IntPoint> corners = this.Detector.ProcessImage(this.grayImage);
            for (int i = 0; i < corners.size(); ++i) {
                features.add(new FastRetinaKeypoint(corners.get((int)i).x, corners.get((int)i).y));
            }
        } else {
            List<FeaturePoint> corners = this.FDetector.ProcessImage(this.grayImage);
            for (int i = 0; i < corners.size(); ++i) {
                features.add(new FastRetinaKeypoint(corners.get((int)i).x, corners.get((int)i).y));
            }
        }
        this.integral = IntegralImage.FromFastBitmap(this.grayImage);
        this.descriptor = null;
        if (this.featureType != FastRetinaKeypointDescriptorType.None) {
            this.descriptor = this.GetDescriptor();
            this.descriptor.Compute(features);
        }
        return features;
    }

    public static enum FastRetinaKeypointDescriptorType {
        None,
        Standard,
        Extended;

    }
}

