/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Variance
implements IApplyInPlace {
    private int radius = 2;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public Variance() {
    }

    public Variance(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new CThread(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CThread
    implements Runnable {
        private Share share;

        public CThread(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int safe = Variance.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int j;
                        int i;
                        double mean = 0.0;
                        double var = 0.0;
                        int total = 0;
                        for (i = x - Variance.this.radius; i <= x + Variance.this.radius; ++i) {
                            for (j = y - Variance.this.radius; j <= y + Variance.this.radius; ++j) {
                                if (i < 0 || i >= this.share.endHeight + safe || j < 0 || j >= this.share.fastBitmap.getWidth()) continue;
                                mean += (double)Variance.this.copy.getGray(i, j);
                                ++total;
                            }
                        }
                        mean /= (double)total;
                        for (i = x - Variance.this.radius; i <= x + Variance.this.radius; ++i) {
                            for (j = y - Variance.this.radius; j <= y + Variance.this.radius; ++j) {
                                if (i < 0 || i >= this.share.endHeight + safe || j < 0 || j >= this.share.fastBitmap.getWidth()) continue;
                                var += Math.pow((double)Variance.this.copy.getGray(i, j) - mean, 2.0);
                            }
                        }
                        if ((var /= (double)(total - 1)) < 0.0) {
                            var = 0.0;
                        }
                        if (var > 255.0) {
                            var = 255.0;
                        }
                        this.share.fastBitmap.setGray(x, y, (int)var);
                    }
                }
            } else {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int j;
                        int i;
                        double meanR = 0.0;
                        double meanG = 0.0;
                        double meanB = 0.0;
                        double varR = 0.0;
                        double varG = 0.0;
                        double varB = 0.0;
                        int total = 0;
                        for (i = x - Variance.this.radius; i <= x + Variance.this.radius; ++i) {
                            for (j = y - Variance.this.radius; j <= y + Variance.this.radius; ++j) {
                                if (i < 0 || i >= this.share.endHeight + safe || j < 0 || j >= this.share.fastBitmap.getWidth()) continue;
                                meanR += (double)Variance.this.copy.getRed(i, j);
                                meanG += (double)Variance.this.copy.getGreen(i, j);
                                meanB += (double)Variance.this.copy.getBlue(i, j);
                                ++total;
                            }
                        }
                        meanR /= (double)total;
                        meanG /= (double)total;
                        meanB /= (double)total;
                        for (i = x - Variance.this.radius; i <= x + Variance.this.radius; ++i) {
                            for (j = y - Variance.this.radius; j <= y + Variance.this.radius; ++j) {
                                if (i < 0 || i >= this.share.endHeight + safe || j < 0 || j >= this.share.fastBitmap.getWidth()) continue;
                                varR += Math.pow((double)Variance.this.copy.getRed(i, j) - meanR, 2.0);
                                varG += Math.pow((double)Variance.this.copy.getGreen(i, j) - meanG, 2.0);
                                varB += Math.pow((double)Variance.this.copy.getBlue(i, j) - meanB, 2.0);
                            }
                        }
                        varR /= (double)(total - 1);
                        varG /= (double)(total - 1);
                        varB /= (double)(total - 1);
                        if (varR < 0.0) {
                            varR = 0.0;
                        }
                        if (varG < 0.0) {
                            varG = 0.0;
                        }
                        if (varB < 0.0) {
                            varB = 0.0;
                        }
                        if (varR > 255.0) {
                            varR = 255.0;
                        }
                        if (varG > 255.0) {
                            varG = 255.0;
                        }
                        if (varB > 255.0) {
                            varB = 255.0;
                        }
                        this.share.fastBitmap.setRGB(x, y, (int)varR, (int)varG, (int)varB);
                    }
                }
            }
        }

        private int CalcLines(int radius) {
            return radius * 2 + 1;
        }
    }
}

