/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Threshold
implements IApplyInPlace {
    private int threshold = 128;

    public int getValue() {
        return this.threshold;
    }

    public void setValue(int threshold) {
        this.threshold = threshold;
    }

    public Threshold() {
    }

    public Threshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        if (!fb.isGrayscale()) {
            throw new IllegalArgumentException("Threshold only works in grayscale images.");
        }
        this.Parallel(fb);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int processors = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[processors];
        int part = fastBitmap.getHeight() / processors;
        int startX = 0;
        for (i = 0; i < processors; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < processors; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                    int x = this.share.fastBitmap.getGray(i, j);
                    if (x < Threshold.this.threshold) {
                        this.share.fastBitmap.setGray(i, j, 0);
                        continue;
                    }
                    this.share.fastBitmap.setGray(i, j, 255);
                }
            }
        }
    }
}

