/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class SobelEdgeDetector
implements IApplyInPlace {
    private FastBitmap copy;
    private int max = 0;
    private boolean scaleIntensity = true;

    public boolean isScaleIntensity() {
        return this.scaleIntensity;
    }

    public void setScaleIntensity(boolean scaleIntensity) {
        this.scaleIntensity = scaleIntensity;
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        this.copy = new FastBitmap(fb);
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int lastT = cores - 1;
        int endWidth = fb.getWidth() - 1;
        int startX = 1;
        for (i = 0; i < cores; ++i) {
            if (i == lastT) {
                part = fb.getHeight() - startX - 1;
            }
            t[i] = new Thread(new Run(new Share(fb, startX, 1, endWidth, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = this.share.startY; j < this.share.endWidth; ++j) {
                    int p1 = SobelEdgeDetector.this.copy.getGray(i - 1, j - 1);
                    int p2 = SobelEdgeDetector.this.copy.getGray(i - 1, j);
                    int p3 = SobelEdgeDetector.this.copy.getGray(i - 1, j + 1);
                    int p4 = SobelEdgeDetector.this.copy.getGray(i, j + 1);
                    int p5 = SobelEdgeDetector.this.copy.getGray(i + 1, j);
                    int p6 = SobelEdgeDetector.this.copy.getGray(i + 1, j + 1);
                    int p7 = SobelEdgeDetector.this.copy.getGray(i + 1, j - 1);
                    int p8 = SobelEdgeDetector.this.copy.getGray(i, j - 1);
                    int g = Math.min(255, Math.abs(p1 + p3 - p7 - p2 + 2 * (p2 - p5)) + Math.abs(p2 + p6 - p1 - p7 + 2 * (p4 - p8)));
                    if (g > SobelEdgeDetector.this.max) {
                        SobelEdgeDetector.this.max = g;
                    }
                    this.share.fastBitmap.setGray(i, j, g);
                }
            }
            if (SobelEdgeDetector.this.scaleIntensity && SobelEdgeDetector.this.max != 255) {
                double factor = 255.0 / (double)SobelEdgeDetector.this.max;
                for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (int j = this.share.startY; j < this.share.endWidth; ++j) {
                        this.share.fastBitmap.setGray(i, j, (int)((double)this.share.fastBitmap.getGray(i, j) * factor));
                    }
                }
            }
        }
    }
}

