/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Filters.FastVariance;
import Catalano.Imaging.Concurrent.Filters.Mean;
import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class SauvolaThreshold
implements IApplyInPlace {
    private Mean.Arithmetic arithmetic = Mean.Arithmetic.Mean;
    private int radius = 15;
    private double k = 0.5;
    private double r = 128.0;
    private FastBitmap mean;
    private FastBitmap var;

    public Mean.Arithmetic getArithmetic() {
        return this.arithmetic;
    }

    public void setArithmetic(Mean.Arithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double k) {
        this.k = k;
    }

    public double getR() {
        return this.r;
    }

    public void setR(double r) {
        this.r = r;
    }

    public SauvolaThreshold() {
    }

    public SauvolaThreshold(int radius) {
        this.radius = radius;
    }

    public SauvolaThreshold(double k, double r) {
        this.k = k;
        this.r = r;
    }

    public SauvolaThreshold(int radius, double k, double r) {
        this.radius = radius;
        this.k = k;
        this.r = r;
    }

    public SauvolaThreshold(int radius, double k, double r, Mean.Arithmetic arithmetic) {
        this.radius = radius;
        this.k = k;
        this.r = r;
        this.arithmetic = arithmetic;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        if (!fastBitmap.isGrayscale()) {
            throw new IllegalArgumentException("Sauvola threshold only works in grayscale images.");
        }
        this.mean = new FastBitmap(fastBitmap);
        this.var = new FastBitmap(fastBitmap);
        Mean m = new Mean(this.radius, this.arithmetic);
        m.applyInPlace(this.mean);
        FastVariance v = new FastVariance(this.radius);
        v.applyInPlace(this.var);
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int lastC = cores - 1;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (lastC == i) {
                part = fastBitmap.getHeight() - startX;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                    float P = this.share.fastBitmap.getGray(i, j);
                    float mP = SauvolaThreshold.this.mean.getGray(i, j);
                    float vP = SauvolaThreshold.this.var.getGray(i, j);
                    int g = (double)P > (double)mP * (1.0 + SauvolaThreshold.this.k * (Math.sqrt(vP) / SauvolaThreshold.this.r - 1.0)) ? 255 : 0;
                    this.share.fastBitmap.setGray(i, j, g);
                }
            }
        }
    }
}

