/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Filters.Threshold;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class SISThreshold
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        int val = this.CalculateThreshold(fastBitmap);
        Threshold t = new Threshold(val);
        t.applyInPlace(fastBitmap);
    }

    public int CalculateThreshold(FastBitmap fastBitmap) {
        if (fastBitmap.isGrayscale()) {
            double weightTotal = 0.0;
            double total = 0.0;
            int width = fastBitmap.getWidth() - 1;
            int height = fastBitmap.getHeight() - 1;
            for (int i = 1; i < height; ++i) {
                for (int j = 1; j < width; ++j) {
                    double ej;
                    double ei = Math.abs(fastBitmap.getGray(i + 1, j) - fastBitmap.getGray(i - 1, j));
                    double weight = ei > (ej = (double)Math.abs(fastBitmap.getGray(i, j + 1) - fastBitmap.getGray(i, j - 1))) ? ei : ej;
                    weightTotal += weight;
                    total += weight * (double)fastBitmap.getGray(i, j);
                }
            }
            return weightTotal == 0.0 ? 0 : (int)(total / weightTotal);
        }
        throw new IllegalArgumentException("SIS threshold only works in grayscale images.");
    }
}

