/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Filters.Dilatation;
import Catalano.Imaging.Concurrent.Filters.Erosion;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.Filters.Subtract;
import Catalano.Imaging.IApplyInPlace;

public class MorphologicGradientImage
implements IApplyInPlace {
    private int[][] kernel;
    private int radius = 1;
    private boolean applyRadius = true;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.applyRadius = true;
    }

    public int[][] getKernel() {
        return this.kernel;
    }

    public void setKernel(int[][] kernel) {
        this.kernel = kernel;
        this.applyRadius = false;
    }

    public MorphologicGradientImage() {
    }

    public MorphologicGradientImage(int radius) {
        this.radius = radius;
        this.applyRadius = true;
    }

    public MorphologicGradientImage(int[][] kernel) {
        this.kernel = kernel;
        this.applyRadius = false;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        FastBitmap temp;
        if (fastBitmap.isGrayscale()) {
            Dilatation dil;
            temp = new FastBitmap(fastBitmap);
            if (this.applyRadius) {
                dil = new Dilatation(this.radius);
                dil.applyInPlace(fastBitmap);
                Erosion ero = new Erosion(this.radius);
                ero.applyInPlace(temp);
            } else {
                dil = new Dilatation(this.kernel);
                dil.applyInPlace(fastBitmap);
                Erosion ero = new Erosion(this.kernel);
                ero.applyInPlace(temp);
            }
        } else {
            throw new IllegalArgumentException("Morphologic Gradient Image only works with grayscale images.");
        }
        Subtract sub = new Subtract(temp);
        sub.applyInPlace(fastBitmap);
    }
}

