/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Mean
implements IApplyInPlace {
    private int radius = 1;
    private FastBitmap copy;
    private Arithmetic arithmetic = Arithmetic.Mean;
    private int order = 1;

    public Mean() {
    }

    public Mean(int radius) {
        this.radius = radius = radius < 1 ? 1 : radius;
    }

    public Mean(Arithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }

    public Mean(int radius, Arithmetic arithmetic) {
        this.radius = radius = radius < 1 ? 1 : radius;
        this.arithmetic = arithmetic;
    }

    public Arithmetic getArithmetic() {
        return this.arithmetic;
    }

    public void setArithmetic(Arithmetic arithmetic) {
        this.arithmetic = arithmetic;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int orderFilter) {
        this.order = orderFilter;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.copy = new FastBitmap(fastBitmap);
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int part;
        int processors = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[processors];
        int endHeight = part = fastBitmap.getHeight() / processors;
        int last = processors - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < processors; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, endHeight, lastThread)));
            t[i].start();
            startX = endHeight;
            endHeight += part;
        }
        try {
            for (i = 0; i < processors; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private int CalcLines(int radius) {
        return radius * 2 + 1;
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines = Mean.this.CalcLines(Mean.this.radius);
            int safe = Mean.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            switch (Mean.this.arithmetic) {
                case Mean: {
                    if (this.share.fastBitmap.isGrayscale()) {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                int c = 0;
                                int sumGray = 0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumGray += Mean.this.copy.getGray(Xline, Yline);
                                        ++c;
                                    }
                                }
                                this.share.fastBitmap.setGray(x, y, sumGray /= c);
                            }
                        }
                    } else {
                        if (!this.share.fastBitmap.isRGB()) break;
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                int c = 0;
                                int sumB = 0;
                                int sumG = 0;
                                int sumR = 0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumR += Mean.this.copy.getRed(Xline, Yline);
                                        sumG += Mean.this.copy.getGreen(Xline, Yline);
                                        sumB += Mean.this.copy.getBlue(Xline, Yline);
                                        ++c;
                                    }
                                }
                                this.share.fastBitmap.setRGB(x, y, sumR /= c, sumG /= c, sumB /= c);
                            }
                        }
                    }
                    break;
                }
                case Harmonic: {
                    if (this.share.fastBitmap.isGrayscale()) {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                int c = 0;
                                double sumGray = 0.0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumGray += 1.0 / (double)Mean.this.copy.getGray(Xline, Yline);
                                        ++c;
                                    }
                                }
                                sumGray = (double)c / sumGray;
                                this.share.fastBitmap.setGray(x, y, (int)sumGray);
                            }
                        }
                    } else {
                        if (!this.share.fastBitmap.isRGB()) break;
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                int c = 0;
                                double sumB = 0.0;
                                double sumG = 0.0;
                                double sumR = 0.0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumR += 1.0 / (double)Mean.this.copy.getRed(Xline, Yline);
                                        sumG += 1.0 / (double)Mean.this.copy.getGreen(Xline, Yline);
                                        sumB += 1.0 / (double)Mean.this.copy.getBlue(Xline, Yline);
                                        ++c;
                                    }
                                }
                                sumR = (double)c / sumR;
                                sumG = (double)c / sumG;
                                sumB = (double)c / sumB;
                                this.share.fastBitmap.setRGB(x, y, (int)sumR, (int)sumG, (int)sumB);
                            }
                        }
                    }
                    break;
                }
                case ContraHarmonic: {
                    if (this.share.fastBitmap.isGrayscale()) {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double sumGrayTwo = 0.0;
                                double sumGrayOne = 0.0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumGrayOne += Math.pow(Mean.this.copy.getGray(Xline, Yline), Mean.this.order + 1);
                                        sumGrayTwo += Math.pow(Mean.this.copy.getGray(Xline, Yline), Mean.this.order);
                                    }
                                }
                                double sumGray = sumGrayOne / sumGrayTwo;
                                this.share.fastBitmap.setGray(x, y, (int)sumGray);
                            }
                        }
                    } else {
                        if (!this.share.fastBitmap.isRGB()) break;
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                double sumBone = 0.0;
                                double sumGone = 0.0;
                                double sumRone = 0.0;
                                double sumBtwo = 0.0;
                                double sumGtwo = 0.0;
                                double sumRtwo = 0.0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumRone += Math.pow(Mean.this.copy.getRed(Xline, Yline), Mean.this.order + 1);
                                        sumGone += Math.pow(Mean.this.copy.getGreen(Xline, Yline), Mean.this.order + 1);
                                        sumBone += Math.pow(Mean.this.copy.getBlue(Xline, Yline), Mean.this.order + 1);
                                        sumRtwo += Math.pow(Mean.this.copy.getRed(Xline, Yline), Mean.this.order);
                                        sumGtwo += Math.pow(Mean.this.copy.getGreen(Xline, Yline), Mean.this.order);
                                        sumBtwo += Math.pow(Mean.this.copy.getBlue(Xline, Yline), Mean.this.order);
                                    }
                                }
                                double sumR = sumRone / sumRtwo;
                                double sumG = sumGone / sumGtwo;
                                double sumB = sumBone / sumBtwo;
                                this.share.fastBitmap.setRGB(x, y, (int)sumR, (int)sumG, (int)sumB);
                            }
                        }
                    }
                    break;
                }
                case Geometry: {
                    if (this.share.fastBitmap.isGrayscale()) {
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                int c = 0;
                                double sumGray = 1.0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumGray *= (double)Mean.this.copy.getGray(Xline, Yline);
                                        ++c;
                                    }
                                }
                                sumGray = Math.pow(sumGray, 1.0 / (double)c);
                                this.share.fastBitmap.setGray(x, y, (int)sumGray);
                            }
                        }
                    } else {
                        if (!this.share.fastBitmap.isRGB()) break;
                        for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                            for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                                int c = 0;
                                double sumB = 1.0;
                                double sumG = 1.0;
                                double sumR = 1.0;
                                for (int i = 0; i < lines; ++i) {
                                    int Xline = x + (i - Mean.this.radius);
                                    for (int j = 0; j < lines; ++j) {
                                        int Yline = y + (j - Mean.this.radius);
                                        if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                        sumR *= (double)Mean.this.copy.getRed(Xline, Yline);
                                        sumG *= (double)Mean.this.copy.getGreen(Xline, Yline);
                                        sumB *= (double)Mean.this.copy.getBlue(Xline, Yline);
                                        ++c;
                                    }
                                }
                                sumR = Math.pow(sumR, 1.0 / (double)c);
                                sumG = Math.pow(sumG, 1.0 / (double)c);
                                sumB = Math.pow(sumB, 1.0 / (double)c);
                                this.share.fastBitmap.setRGB(x, y, (int)sumR, (int)sumG, (int)sumB);
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public static enum Arithmetic {
        Mean,
        Harmonic,
        ContraHarmonic,
        Geometry;

    }
}

