/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Maximum
implements IApplyInPlace {
    private int radius = 1;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public Maximum() {
    }

    public Maximum(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new CThread(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CThread
    implements Runnable {
        private Share share;

        public CThread(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines = this.CalcLines(Maximum.this.radius);
            int safe = Maximum.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int max = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - Maximum.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - Maximum.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth() || Maximum.this.copy.getGray(Xline, Yline) <= max) continue;
                                max = Maximum.this.copy.getGray(Xline, Yline);
                            }
                        }
                        this.share.fastBitmap.setGray(x, y, max);
                    }
                }
            } else {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int maxB = 0;
                        int maxG = 0;
                        int maxR = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - Maximum.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - Maximum.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth()) continue;
                                if (Maximum.this.copy.getRed(Xline, Yline) > maxR) {
                                    maxR = Maximum.this.copy.getRed(Xline, Yline);
                                }
                                if (Maximum.this.copy.getGreen(Xline, Yline) > maxG) {
                                    maxG = Maximum.this.copy.getGreen(Xline, Yline);
                                }
                                if (Maximum.this.copy.getBlue(Xline, Yline) <= maxB) continue;
                                maxB = Maximum.this.copy.getBlue(Xline, Yline);
                            }
                        }
                        this.share.fastBitmap.setRGB(x, y, maxR, maxG, maxB);
                    }
                }
            }
        }

        private int CalcLines(int radius) {
            return radius * 2 + 1;
        }
    }
}

