/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class Invert
implements IApplyInPlace {
    @Override
    public void applyInPlace(FastBitmap fb) {
        this.Parallel(fb);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            if (this.share.fastBitmap.isGrayscale()) {
                for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        int x = 255 - this.share.fastBitmap.getGray(i, j);
                        this.share.fastBitmap.setGray(i, j, x);
                    }
                }
            } else {
                for (int i = this.share.startX; i < this.share.endHeight; ++i) {
                    for (int j = 0; j < this.share.fastBitmap.getWidth(); ++j) {
                        int r = 255 - this.share.fastBitmap.getRed(i, j);
                        int g = 255 - this.share.fastBitmap.getGreen(i, j);
                        int b = 255 - this.share.fastBitmap.getBlue(i, j);
                        this.share.fastBitmap.setRGB(i, j, r, g, b);
                    }
                }
            }
        }
    }
}

