/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class DifferenceEdgeDetector
implements IApplyInPlace {
    private FastBitmap copy;
    private int max = 0;

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        int cores = Runtime.getRuntime().availableProcessors();
        this.copy = new FastBitmap(fb);
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int lastT = cores - 1;
        int endWidth = fb.getWidth() - 1;
        int startX = 1;
        for (i = 0; i < cores; ++i) {
            if (i == lastT) {
                part = fb.getHeight() - startX - 1;
            }
            t[i] = new Thread(new Run(new Share(fb, startX, 1, endWidth, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                for (int y = this.share.startY; y < this.share.endWidth; ++y) {
                    int max = 0;
                    int diff = DifferenceEdgeDetector.this.copy.getGray(x - 1, y - 1) - DifferenceEdgeDetector.this.copy.getGray(x + 1, y + 1);
                    if (diff < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    if ((diff = DifferenceEdgeDetector.this.copy.getGray(x - 1, y) - DifferenceEdgeDetector.this.copy.getGray(x + 1, y)) < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    if ((diff = DifferenceEdgeDetector.this.copy.getGray(x - 1, y + 1) - DifferenceEdgeDetector.this.copy.getGray(x + 1, y - 1)) < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    if ((diff = DifferenceEdgeDetector.this.copy.getGray(x, y + 1) - DifferenceEdgeDetector.this.copy.getGray(x, y - 1)) < 0) {
                        diff = -diff;
                    }
                    if (diff > max) {
                        max = diff;
                    }
                    this.share.fastBitmap.setGray(x, y, max);
                }
            }
        }
    }
}

