/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;

public class ConservativeSmoothing
implements IApplyInPlace {
    private int radius = 1;
    private FastBitmap copy;

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = Math.max(1, radius);
    }

    public ConservativeSmoothing() {
    }

    public ConservativeSmoothing(int radius) {
        this.setRadius(radius);
    }

    @Override
    public void applyInPlace(FastBitmap fb) {
        int i;
        this.copy = new FastBitmap(fb);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fb.getHeight() / cores;
        int last = cores - 1;
        boolean lastThread = false;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            if (i == last) {
                lastThread = true;
            }
            t[i] = new Thread(new CThread(new Share(fb, startX, startX += part, lastThread)));
            t[i].start();
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class CThread
    implements Runnable {
        private Share share;

        public CThread(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int lines = this.CalcLines(ConservativeSmoothing.this.radius);
            int safe = ConservativeSmoothing.this.radius;
            if (this.share.lastThread) {
                safe = 0;
                this.share.endHeight = this.share.fastBitmap.getHeight();
            }
            if (this.share.fastBitmap.isGrayscale()) {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int minG = 255;
                        int maxG = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - ConservativeSmoothing.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - ConservativeSmoothing.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth() || i == j) continue;
                                if (ConservativeSmoothing.this.copy.getGray(Xline, Yline) > maxG) {
                                    maxG = ConservativeSmoothing.this.copy.getGray(Xline, Yline);
                                }
                                if (ConservativeSmoothing.this.copy.getGray(Xline, Yline) >= minG) continue;
                                minG = ConservativeSmoothing.this.copy.getGray(Xline, Yline);
                            }
                        }
                        int g = ConservativeSmoothing.this.copy.getGray(x, y);
                        if (g > maxG) {
                            g = maxG;
                        }
                        if (g < minG) {
                            g = minG;
                        }
                        this.share.fastBitmap.setGray(x, y, g);
                    }
                }
            } else {
                for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                    for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                        int minB = 255;
                        int minG = 255;
                        int minR = 255;
                        int maxB = 0;
                        int maxG = 0;
                        int maxR = 0;
                        for (int i = 0; i < lines; ++i) {
                            int Xline = x + (i - ConservativeSmoothing.this.radius);
                            for (int j = 0; j < lines; ++j) {
                                int Yline = y + (j - ConservativeSmoothing.this.radius);
                                if (Xline < 0 || Xline >= this.share.endHeight + safe || Yline < 0 || Yline >= this.share.fastBitmap.getWidth() || i == j) continue;
                                if (ConservativeSmoothing.this.copy.getRed(Xline, Yline) > maxR) {
                                    maxR = ConservativeSmoothing.this.copy.getRed(Xline, Yline);
                                }
                                if (ConservativeSmoothing.this.copy.getGreen(Xline, Yline) > maxG) {
                                    maxG = ConservativeSmoothing.this.copy.getGreen(Xline, Yline);
                                }
                                if (ConservativeSmoothing.this.copy.getBlue(Xline, Yline) > maxB) {
                                    maxB = ConservativeSmoothing.this.copy.getBlue(Xline, Yline);
                                }
                                if (ConservativeSmoothing.this.copy.getRed(Xline, Yline) < minR) {
                                    minR = ConservativeSmoothing.this.copy.getRed(Xline, Yline);
                                }
                                if (ConservativeSmoothing.this.copy.getGreen(Xline, Yline) < minG) {
                                    minG = ConservativeSmoothing.this.copy.getGreen(Xline, Yline);
                                }
                                if (ConservativeSmoothing.this.copy.getBlue(Xline, Yline) >= minB) continue;
                                minB = ConservativeSmoothing.this.copy.getBlue(Xline, Yline);
                            }
                        }
                        int r = ConservativeSmoothing.this.copy.getRed(x, y);
                        int g = ConservativeSmoothing.this.copy.getGreen(x, y);
                        int b = ConservativeSmoothing.this.copy.getBlue(x, y);
                        if (r > maxR) {
                            r = maxR;
                        }
                        if (g > maxG) {
                            g = maxG;
                        }
                        if (b > maxB) {
                            b = maxB;
                        }
                        if (r < minR) {
                            r = minR;
                        }
                        if (g < minG) {
                            g = minG;
                        }
                        if (b < minB) {
                            b = minB;
                        }
                        this.share.fastBitmap.setRGB(x, y, r, g, b);
                    }
                }
            }
        }

        private int CalcLines(int radius) {
            return radius * 2 + 1;
        }
    }
}

