/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Imaging.Concurrent.Filters;

import Catalano.Imaging.Concurrent.Share;
import Catalano.Imaging.FastBitmap;
import Catalano.Imaging.IApplyInPlace;
import Catalano.Imaging.Tools.IntegralImage;

public class BradleyLocalThreshold
implements IApplyInPlace {
    private int windowSize = 41;
    private float pixelBrightnessDifferenceLimit = 0.15f;
    private IntegralImage im;

    public BradleyLocalThreshold() {
    }

    public BradleyLocalThreshold(int windowSize) {
        this.windowSize = windowSize;
    }

    public BradleyLocalThreshold(int windowSize, float pixelBrightnessDiff) {
        this.windowSize = windowSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public float getPixelBrightnessDifferenceLimit() {
        return this.pixelBrightnessDifferenceLimit;
    }

    public void setPixelBrightnessDifferenceLimit(float pixelBrightnessDifferenceLimit) {
        this.pixelBrightnessDifferenceLimit = pixelBrightnessDifferenceLimit;
    }

    @Override
    public void applyInPlace(FastBitmap fastBitmap) {
        this.Parallel(fastBitmap);
    }

    private void Parallel(FastBitmap fastBitmap) {
        int i;
        this.im = IntegralImage.FromFastBitmap(fastBitmap);
        int cores = Runtime.getRuntime().availableProcessors();
        Thread[] t = new Thread[cores];
        int part = fastBitmap.getHeight() / cores;
        int startX = 0;
        for (i = 0; i < cores; ++i) {
            t[i] = new Thread(new Run(new Share(fastBitmap, startX, startX + part)));
            t[i].start();
            startX += part;
        }
        try {
            for (i = 0; i < cores; ++i) {
                t[i].join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private class Run
    implements Runnable {
        private Share share;

        public Run(Share obj) {
            this.share = obj;
        }

        @Override
        public void run() {
            int widthM1 = this.share.fastBitmap.getWidth() - 1;
            int heightM1 = this.share.endHeight - 1;
            int radius = BradleyLocalThreshold.this.windowSize / 2;
            float avgBrightnessPart = 1.0f - BradleyLocalThreshold.this.pixelBrightnessDifferenceLimit;
            for (int x = this.share.startX; x < this.share.endHeight; ++x) {
                int x1 = x - radius;
                int x2 = x + radius;
                if (x1 < 0) {
                    x1 = 0;
                }
                if (x2 > heightM1) {
                    x2 = heightM1;
                }
                for (int y = 0; y < this.share.fastBitmap.getWidth(); ++y) {
                    int y1 = y - radius;
                    int y2 = y + radius;
                    if (y1 < 0) {
                        y1 = 0;
                    }
                    if (y2 > widthM1) {
                        y2 = widthM1;
                    }
                    int gray = this.share.fastBitmap.getGray(x, y) < (int)(BradleyLocalThreshold.this.im.getRectangleMeanUnsafe(x1, y1, x2, y2) * avgBrightnessPart) ? 0 : 255;
                    this.share.fastBitmap.setGray(x, y, gray);
                }
            }
        }
    }
}

