/*
 * Decompiled with CFR 0.152.
 */
package Catalano.IO;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSVParser {
    private char delimiter = (char)44;
    private int startRow = 0;
    private int startCol = 0;
    private int endCol = -1;
    String charset = "UTF-8";
    String newLine = System.getProperty("line.separator");

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public int getStartColumn() {
        return this.startCol;
    }

    public void setStartColumn(int startCol) {
        this.startCol = startCol;
    }

    public int getEndColumn() {
        return this.endCol;
    }

    public void setEndColumn(int endCol) {
        this.endCol = endCol;
    }

    public CSVParser() {
    }

    public CSVParser(char delimiter) {
        this.delimiter = delimiter;
    }

    public CSVParser(char delimiter, int startRow) {
        this.delimiter = delimiter;
        this.startRow = startRow;
    }

    public CSVParser(char delimiter, int startRow, int startColumn) {
        this.delimiter = delimiter;
        this.startRow = startRow;
        this.startCol = startColumn;
    }

    public CSVParser(char delimiter, int startRow, int startColumn, int endColumn) {
        this.delimiter = delimiter;
        this.startRow = startRow;
        this.startCol = startColumn;
        this.endCol = endColumn;
    }

    public <T> List<T> Read(String filename, Class clazz) {
        String[][] data = this.Read(filename);
        return this.toObject(data, clazz);
    }

    public String[][] Read(String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.charset));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            if (this.endCol == -1) {
                this.endCol = ((String)lines.get(this.startRow)).split(String.valueOf(this.delimiter)).length;
            }
            if (lines.size() > 0) {
                String[] temp = ((String)lines.get(this.startRow)).split(String.valueOf(this.delimiter));
                String[][] data = new String[lines.size() - this.startRow][temp.length - this.startCol];
                int idxI = 0;
                for (int i = this.startRow; i < lines.size(); ++i) {
                    int idxJ = 0;
                    temp = ((String)lines.get(i)).split(String.valueOf(this.delimiter));
                    for (int j = this.startCol; j < this.endCol; ++j) {
                        data[idxI][idxJ] = temp[j];
                        ++idxJ;
                    }
                    ++idxI;
                }
                return data;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public double[][] ReadAsDouble(String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.charset));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            if (this.endCol == -1) {
                this.endCol = ((String)lines.get(this.startRow)).split(String.valueOf(this.delimiter)).length;
            }
            if (lines.size() > 0) {
                String[] temp = ((String)lines.get(this.startRow)).split(String.valueOf(this.delimiter));
                double[][] data = new double[lines.size() - this.startRow][temp.length - this.startCol];
                int idxI = 0;
                for (int i = this.startRow; i < lines.size(); ++i) {
                    int idxJ = 0;
                    temp = ((String)lines.get(i)).split(String.valueOf(this.delimiter));
                    for (int j = this.startCol; j < this.endCol; ++j) {
                        String t = CSVParser.fix(temp[j]);
                        data[idxI][idxJ] = t.equals("") ? Double.NaN : Double.valueOf(t);
                        ++idxJ;
                    }
                    ++idxI;
                }
                return data;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public int[][] ReadAsInt(String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), this.charset));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            if (this.endCol == -1) {
                this.endCol = ((String)lines.get(this.startRow)).split(String.valueOf(this.delimiter)).length;
            }
            if (lines.size() > 0) {
                String[] temp = ((String)lines.get(this.startRow)).split(String.valueOf(this.delimiter));
                int[][] data = new int[lines.size() - this.startRow][temp.length - this.startCol];
                int idxI = 0;
                for (int i = this.startRow; i < lines.size(); ++i) {
                    int idxJ = 0;
                    temp = ((String)lines.get(i)).split(String.valueOf(this.delimiter));
                    for (int j = this.startCol; j < this.endCol; ++j) {
                        data[idxI][idxJ] = Integer.valueOf(CSVParser.fix(temp[j]));
                        ++idxJ;
                    }
                    ++idxI;
                }
                return data;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private static String fix(String x) {
        String r = "";
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (!Character.isDigit(c) && c != '.' && c != '-' && c != 'E') continue;
            r = r + c;
        }
        return r;
    }

    private <T> List<T> toObject(String[][] data, Class cls) {
        int p = 0;
        Class<?>[] paramTypes = null;
        for (Constructor<?> con : cls.getConstructors()) {
            if (con.getParameterCount() <= p) continue;
            p = con.getParameterCount();
            paramTypes = con.getParameterTypes();
        }
        ArrayList lst = new ArrayList(data.length);
        try {
            for (int i = 0; i < data.length - this.startRow; ++i) {
                Constructor c = cls.getConstructor(paramTypes);
                Object[] obj = new Object[paramTypes.length];
                for (int j = 0; j < paramTypes.length; ++j) {
                    if (paramTypes[j] == Integer.TYPE) {
                        obj[j] = Integer.parseInt(data[i][j]);
                        continue;
                    }
                    if (paramTypes[j] == Boolean.TYPE) {
                        obj[j] = Boolean.parseBoolean(data[i][j]);
                        continue;
                    }
                    if (paramTypes[j] == Double.TYPE) {
                        obj[j] = Double.parseDouble(data[i][j]);
                        continue;
                    }
                    if (paramTypes[j] == Float.TYPE) {
                        obj[j] = Float.valueOf(Float.parseFloat(data[i][j]));
                        continue;
                    }
                    if (paramTypes[j] != String.class) continue;
                    obj[j] = data[i][j];
                }
                lst.add(c.newInstance(obj));
            }
            return lst;
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public void Write(String[][] data, String filename) {
        try {
            FileWriter fw = new FileWriter(filename);
            for (int i = 0; i < data.length; ++i) {
                boolean isLastCol = false;
                for (int j = 0; j < data[0].length; ++j) {
                    if (j == data[0].length - 1) {
                        isLastCol = true;
                    }
                    if (isLastCol) {
                        fw.append(data[i][j]);
                        continue;
                    }
                    fw.append(data[i][j] + this.delimiter);
                }
                fw.append(this.newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void Write(int[][] data, String filename) {
        try {
            FileWriter fw = new FileWriter(filename);
            for (int i = 0; i < data.length; ++i) {
                boolean isLastCol = false;
                for (int j = 0; j < data[0].length; ++j) {
                    if (j == data[0].length - 1) {
                        isLastCol = true;
                    }
                    if (isLastCol) {
                        fw.append(String.valueOf(data[i][j]));
                        continue;
                    }
                    fw.append(String.valueOf(data[i][j]) + this.delimiter);
                }
                fw.append(this.newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void Write(double[][] data, String filename) {
        this.Write(data, filename, -1);
    }

    public void Write(double[][] data, String filename, int decimalPlaces) {
        try {
            String dec = "%." + decimalPlaces + "f";
            FileWriter fw = new FileWriter(filename);
            for (int i = 0; i < data.length; ++i) {
                boolean isLastCol = false;
                for (int j = 0; j < data[0].length; ++j) {
                    if (j == data[0].length - 1) {
                        isLastCol = true;
                    }
                    if (decimalPlaces >= 0) {
                        if (isLastCol) {
                            fw.append(String.format(Locale.US, dec, data[i][j]));
                            continue;
                        }
                        fw.append(String.format(Locale.US, dec, data[i][j]) + this.delimiter);
                        continue;
                    }
                    if (isLastCol) {
                        fw.append(String.valueOf(data[i][j]));
                        continue;
                    }
                    fw.append(String.valueOf(data[i][j]) + this.delimiter);
                }
                fw.append(this.newLine);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CSVParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

