/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Graph.Network;

import Catalano.Graph.AdjacencyMatrix;
import Catalano.Math.Matrix;

public class Hits {
    private double epsilon = 0.001;
    private double[] authority;
    private double[] hubs;
    private int it = 0;

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double epsilon) {
        if (epsilon == 0.0) {
            throw new IllegalArgumentException("The epsilon value must be different of zero.");
        }
        this.epsilon = epsilon;
    }

    public int getNumberOfIterations() {
        return this.it;
    }

    public double[] getAuthority() {
        return this.authority;
    }

    public double[] getHubs() {
        return this.hubs;
    }

    public Hits(AdjacencyMatrix matrix) {
        this.Compute(matrix);
    }

    public Hits(AdjacencyMatrix matrix, double epsilon) {
        this.setEpsilon(epsilon);
        this.Compute(matrix);
    }

    public void Compute(AdjacencyMatrix matrix) {
        double[] weights = Matrix.CreateMatrix1D(matrix.getData().length, 1.0);
        this.Compute(matrix, weights);
    }

    public void Compute(AdjacencyMatrix matrix, double[] weights) {
        if (matrix.getData().length != weights.length) {
            throw new IllegalArgumentException("The matrix lenght must be the same lenght of the weights.");
        }
        double[][] mA = Matrix.Multiply(Matrix.Transpose(matrix.getData()), matrix.getData());
        double[][] mH = Matrix.MultiplyByTranspose(matrix.getData(), matrix.getData());
        this.authority = weights;
        this.hubs = weights;
        double maxDiff = Double.MAX_VALUE;
        while (maxDiff > this.epsilon) {
            double[] a = this.Iteration(mA, this.authority);
            double[] h = this.Iteration(mH, this.hubs);
            maxDiff = this.Convergency(this.authority, this.hubs, a, h);
            this.authority = a;
            this.hubs = h;
            ++this.it;
        }
    }

    private double[] Iteration(double[][] m, double[] a) {
        int i;
        double[] result = new double[a.length];
        double sum = 0.0;
        for (i = 0; i < m.length; ++i) {
            double r = 0.0;
            for (int j = 0; j < m[0].length; ++j) {
                r += m[i][j] * a[j];
            }
            result[i] = r;
            sum += r;
        }
        i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = result[n] / sum;
        }
        return result;
    }

    private double Convergency(double[] oldAuthority, double[] oldHubs, double[] authority, double[] hubs) {
        double maxDiff = Double.MAX_VALUE;
        for (int i = 0; i < oldAuthority.length; ++i) {
            maxDiff = Math.min(maxDiff, Math.abs(oldAuthority[i] - authority[i]));
            maxDiff = Math.min(maxDiff, Math.abs(oldHubs[i] - hubs[i]));
        }
        return maxDiff;
    }
}

