/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Fuzzy;

import Catalano.Core.FloatPoint;
import Catalano.Fuzzy.PiecewiseLinearFunction;

public class TrapezoidalFunction
extends PiecewiseLinearFunction {
    private TrapezoidalFunction(int size) {
        this.points = new FloatPoint[size];
    }

    public TrapezoidalFunction(float m1, float m2, float m3, float m4, float max, float min) {
        this(4);
        this.points[0] = new FloatPoint(m1, min);
        this.points[1] = new FloatPoint(m2, max);
        this.points[2] = new FloatPoint(m3, max);
        this.points[3] = new FloatPoint(m4, min);
    }

    public TrapezoidalFunction(float m1, float m2, float m3, float m4) {
        this(m1, m2, m3, m4, 1.0f, 0.0f);
    }

    public TrapezoidalFunction(float m1, float m2, float m3, float max, float min) {
        this(3);
        this.points[0] = new FloatPoint(m1, min);
        this.points[1] = new FloatPoint(m2, max);
        this.points[2] = new FloatPoint(m3, min);
    }

    public TrapezoidalFunction(float m1, float m2, float m3) {
        this(m1, m2, m3, 1.0f, 0.0f);
    }

    public TrapezoidalFunction(float m1, float m2, float max, float min, EdgeType edge) {
        this(2);
        if (edge == EdgeType.Left) {
            this.points[0] = new FloatPoint(m1, min);
            this.points[1] = new FloatPoint(m2, max);
        } else {
            this.points[0] = new FloatPoint(m1, max);
            this.points[1] = new FloatPoint(m2, min);
        }
    }

    public TrapezoidalFunction(float m1, float m2, EdgeType edge) {
        this(m1, m2, 1.0f, 0.0f, edge);
    }

    public static enum EdgeType {
        Left,
        Right;

    }
}

