/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Fuzzy;

import Catalano.Core.FloatPoint;
import Catalano.Fuzzy.IMembershipFunction;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PiecewiseLinearFunction
implements IMembershipFunction {
    protected FloatPoint[] points;

    public PiecewiseLinearFunction() {
        this.points = null;
    }

    public PiecewiseLinearFunction(FloatPoint[] points) {
        this.points = points;
        int n = points.length;
        for (int i = 0; i < n; ++i) {
            if (points[i].y < 0.0f || points[i].y > 1.0f) {
                try {
                    throw new Exception("Y value of points must be in the range of [0, 1].");
                }
                catch (Exception ex) {
                    Logger.getLogger(PiecewiseLinearFunction.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (i == 0 || !(points[i - 1].x > points[i].x)) continue;
            try {
                throw new Exception("Points must be in crescent order on X axis.");
            }
            catch (Exception ex) {
                Logger.getLogger(PiecewiseLinearFunction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public float GetMembership(float x) {
        if (this.points.length == 0) {
            return 0.0f;
        }
        if (x < this.points[0].x) {
            return this.points[0].y;
        }
        int n = this.points.length;
        for (int i = 1; i < n; ++i) {
            if (!(x < this.points[i].x)) continue;
            float y1 = this.points[i].y;
            float y0 = this.points[i - 1].y;
            float x1 = this.points[i].x;
            float x0 = this.points[i - 1].x;
            float m = (y1 - y0) / (x1 - x0);
            return m * (x - x0) + y0;
        }
        return this.points[this.points.length - 1].y;
    }

    @Override
    public float LeftLimit() {
        return this.points[0].x;
    }

    @Override
    public float RightLimit() {
        return this.points[this.points.length - 1].x;
    }
}

