/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Fuzzy;

import Catalano.Fuzzy.Database;
import Catalano.Fuzzy.FuzzyOutput;
import Catalano.Fuzzy.ICoNorm;
import Catalano.Fuzzy.IDefuzzifier;
import Catalano.Fuzzy.INorm;
import Catalano.Fuzzy.LinguisticVariable;
import Catalano.Fuzzy.MaximumCoNorm;
import Catalano.Fuzzy.MinimumNorm;
import Catalano.Fuzzy.Rule;
import Catalano.Fuzzy.Rulebase;

public class InferenceSystem {
    private Database database;
    private Rulebase rulebase;
    private IDefuzzifier defuzzifier;
    private INorm normOperator;
    private ICoNorm conormOperator;

    public InferenceSystem(Database database, IDefuzzifier defuzzifier, INorm normOperator, ICoNorm conormOperator) {
        this.database = database;
        this.defuzzifier = defuzzifier;
        this.normOperator = normOperator;
        this.conormOperator = conormOperator;
        this.rulebase = new Rulebase();
    }

    public InferenceSystem(Database database, IDefuzzifier defuzzifier) {
        this(database, defuzzifier, new MinimumNorm(), new MaximumCoNorm());
    }

    public Rule NewRule(String name, String rule) {
        Rule r = new Rule(this.database, name, rule, this.normOperator, this.conormOperator);
        this.rulebase.addRule(r);
        return r;
    }

    public void SetInput(String variableName, float value) {
        this.database.getVariable(variableName).setNumericInput(value);
    }

    public LinguisticVariable GetLinguisticVariable(String variableName) {
        return this.database.getVariable(variableName);
    }

    public Rule GetRule(String ruleName) {
        return this.rulebase.getRule(ruleName);
    }

    public float Evaluate(String variableName) {
        FuzzyOutput fuzzyOutput = this.ExecuteInference(variableName);
        float res = this.defuzzifier.Defuzzify(fuzzyOutput, this.normOperator);
        return res;
    }

    public FuzzyOutput ExecuteInference(String variableName) {
        Rule[] rules;
        LinguisticVariable lingVar = this.database.getVariable(variableName);
        FuzzyOutput fuzzyOutput = new FuzzyOutput(lingVar);
        for (Rule r : rules = this.rulebase.getRules()) {
            if (!r.getOutput().getVariable().getName().equals(variableName)) continue;
            String labelName = r.getOutput().getLabel().Name();
            float firingStrength = r.EvaluateFiringStrength();
            if (!(firingStrength > 0.0f)) continue;
            fuzzyOutput.addOutput(labelName, firingStrength);
        }
        return fuzzyOutput;
    }
}

