/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.ArraysUtil;
import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.Individual;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RealCodedGeneticAlgorithm
extends BaseEvolutionaryOptimization {
    private Selection selection;
    private float crossoverPercentage;
    private float mutationPercentage;
    private double mutationRate = 0.1;
    private double beta = 8.0;
    private double maxError;

    public RealCodedGeneticAlgorithm() {
        this(100, 1000);
    }

    public RealCodedGeneticAlgorithm(int population, int generations) {
        this(population, generations, 0.7f, 0.3f);
    }

    public RealCodedGeneticAlgorithm(int population, int generations, float crossoverPercentage, float mutationPercentage) {
        this(population, generations, crossoverPercentage, mutationPercentage, Selection.Random);
    }

    public RealCodedGeneticAlgorithm(int population, int generations, float crossoverPercentage, float mutationPercentage, Selection selection) {
        this.populationSize = population;
        this.generations = generations;
        this.crossoverPercentage = crossoverPercentage;
        this.mutationPercentage = mutationPercentage;
        this.selection = selection;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        Random rand = new Random();
        int popCO = 2 * (int)((float)this.populationSize * this.crossoverPercentage) / 2;
        int popMU = (int)((float)this.populationSize * this.mutationPercentage);
        int pSize = this.populationSize + popCO * 2 + popMU;
        List<Individual> population = new ArrayList<Individual>(pSize);
        for (int i = 0; i < pSize; ++i) {
            double[] values = new double[boundConstraint.size()];
            for (int j = 0; j < values.length; ++j) {
                DoubleRange range = boundConstraint.get(j);
                values[j] = range.getMin() + rand.nextDouble() * (range.getMax() - range.getMin());
            }
            Individual c = new Individual(values, function.Compute(values));
            population.add(c);
        }
        Collections.sort(population);
        this.best = Arrays.copyOf(((Individual)population.get(0)).getLocation(), boundConstraint.size());
        this.minError = ((Individual)population.get(0)).getFitness();
        this.maxError = ((Individual)population.get(population.size() - 1)).getFitness();
        for (int g = 0; g < this.generations; ++g) {
            int i;
            ArrayList<Individual> news = new ArrayList<Individual>(popCO + popMU);
            for (i = 0; i < popCO / 2; ++i) {
                int[] index = null;
                switch (this.selection) {
                    case Random: {
                        index = this.RandomSelection(population);
                        break;
                    }
                    case RoulleteWheelSelection: {
                        index = this.RoulleteWheelSelection(population, this.beta, this.maxError);
                        break;
                    }
                    case Elite: {
                        index = this.EliteSelection();
                    }
                }
                Individual c1 = (Individual)population.get(index[0]);
                Individual c2 = (Individual)population.get(index[1]);
                double[][] elem = this.Crossover(c1.getLocation(), c2.getLocation(), 0.4, boundConstraint);
                c1 = new Individual(elem[0], function.Compute(elem[0]));
                c2 = new Individual(elem[1], function.Compute(elem[1]));
                news.add(c1);
                news.add(c2);
                this.nEvals += 2L;
            }
            for (i = 0; i < popMU; ++i) {
                double[] elem = this.Mutation(((Individual)population.get(rand.nextInt(population.size()))).getLocation(), this.mutationRate, boundConstraint);
                news.add(new Individual(elem, function.Compute(elem)));
                ++this.nEvals;
            }
            population.addAll(news);
            Collections.sort(population);
            this.best = Arrays.copyOf(((Individual)population.get(0)).getLocation(), boundConstraint.size());
            this.minError = ((Individual)population.get(0)).getFitness();
            population = population.subList(0, this.populationSize);
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }

    private int[] EliteSelection() {
        return new int[]{0, 1};
    }

    private int[] RandomSelection(List<Individual> lst) {
        Random rand = new Random();
        int[] index = new int[]{rand.nextInt(lst.size()), rand.nextInt(lst.size())};
        return index;
    }

    private int[] RoulleteWheelSelection(List<Individual> lst, double beta, double worstError) {
        int i;
        Random rand = new Random();
        double[] fitness = new double[lst.size()];
        double sum = 0.0;
        for (i = 0; i < fitness.length; ++i) {
            double v;
            fitness[i] = v = Math.exp(-beta * lst.get(i).getFitness() / worstError);
            sum += v;
        }
        for (i = 0; i < fitness.length; ++i) {
            fitness[i] = fitness[i] / sum;
        }
        sum = fitness[0];
        for (i = 1; i < fitness.length; ++i) {
            fitness[i] = sum += fitness[i];
        }
        int[] index = new int[2];
        for (int i2 = 0; i2 < index.length; ++i2) {
            double v = rand.nextDouble();
            for (int j = 0; j < fitness.length; ++j) {
                if (!(fitness[j] < v)) continue;
                index[i2] = j;
            }
        }
        return index;
    }

    private double[][] Crossover(double[] a, double[] b, double gamma, List<DoubleRange> boundConstraint) {
        Random rand = new Random();
        double min = -gamma;
        double max = 1.0 + gamma;
        double[] alpha = new double[a.length];
        for (int i = 0; i < alpha.length; ++i) {
            alpha[i] = min + rand.nextDouble() * (max - min);
        }
        double[][] y = new double[2][a.length];
        for (int i = 0; i < y[0].length; ++i) {
            double v1 = alpha[i] * a[i] + (1.0 - alpha[i]) * b[i];
            double v2 = alpha[i] * b[i] + (1.0 - alpha[i]) * a[i];
            v1 = Tools.Clamp(v1, boundConstraint.get(i));
            v2 = Tools.Clamp(v2, boundConstraint.get(i));
            y[0][i] = v1;
            y[1][i] = v2;
        }
        return y;
    }

    private double[] Mutation(double[] a, double mu, List<DoubleRange> boundConstraint) {
        Random rand = new Random();
        int[] j = Matrix.Indices(0, a.length);
        ArraysUtil.Shuffle(j);
        int n = (int)Math.ceil(mu * (double)a.length);
        j = Arrays.copyOf(j, n);
        double[] sigma = new double[a.length];
        for (int i = 0; i < sigma.length; ++i) {
            DoubleRange range = boundConstraint.get(i);
            sigma[i] = 0.1 * (range.getMax() - range.getMin());
        }
        double[] y = Arrays.copyOf(a, a.length);
        for (int i = 0; i < j.length; ++i) {
            DoubleRange range = boundConstraint.get(j[i]);
            double v = a[j[i]] + sigma[j[i]] * rand.nextGaussian();
            y[j[i]] = v = Tools.Clamp(v, range);
        }
        return y;
    }

    public static enum Selection {
        Random,
        RoulleteWheelSelection,
        Elite;

    }
}

