/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.Particle;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ParticleSwarmOptimization
extends BaseEvolutionaryOptimization {
    private long seed;
    private double w;
    private double C1;
    private double C2;
    private Random random = new Random();
    private List<Particle> swarm;

    public ParticleSwarmOptimization() {
        this(64, 100);
    }

    public ParticleSwarmOptimization(int swarm, int iterations) {
        this(swarm, iterations, 1.5, 1.5, 0.9);
    }

    public ParticleSwarmOptimization(int swarm, int iterations, double c1, double c2, double w) {
        this(swarm, iterations, c1, c2, w, 0L);
    }

    public ParticleSwarmOptimization(int swarm, int iterations, double c1, double c2, double w, long seed) {
        this.populationSize = swarm;
        this.generations = iterations;
        this.C1 = c1;
        this.C2 = c2;
        this.w = w;
        this.seed = seed;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        ArrayList<DoubleRange> velocity = new ArrayList<DoubleRange>(boundConstraint.size());
        for (int i = 0; i < boundConstraint.size(); ++i) {
            double v = 0.2 * (boundConstraint.get(i).getMax() - boundConstraint.get(i).getMin());
            velocity.add(new DoubleRange(-v, v));
        }
        this.Compute(function, boundConstraint, velocity);
    }

    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint, List<DoubleRange> velocity) {
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        double wf = this.w;
        this.Initialize(this.populationSize, boundConstraint, function, this.seed);
        for (int i = 0; i < this.generations; ++i) {
            for (int j = 0; j < this.populationSize; ++j) {
                int k;
                int k2;
                Particle p = this.swarm.get(j);
                double[] newVelocity = new double[boundConstraint.size()];
                for (k2 = 0; k2 < newVelocity.length; ++k2) {
                    newVelocity[k2] = wf * p.getVelocity()[k2] + this.random.nextDouble() * this.C1 * (p.getBestLocation()[k2] - p.getLocation()[k2]) + this.random.nextDouble() * this.C2 * (this.best[k2] - p.getLocation()[k2]);
                }
                for (k2 = 0; k2 < newVelocity.length; ++k2) {
                    newVelocity[k2] = newVelocity[k2] < velocity.get(k2).getMin() ? velocity.get(k2).getMin() : newVelocity[k2];
                    newVelocity[k2] = newVelocity[k2] > velocity.get(k2).getMax() ? velocity.get(k2).getMax() : newVelocity[k2];
                }
                p.setVelocity(newVelocity);
                double[] newLocation = new double[boundConstraint.size()];
                for (k = 0; k < newLocation.length; ++k) {
                    newLocation[k] = p.getLocation()[k] + newVelocity[k];
                }
                for (k = 0; k < newLocation.length; ++k) {
                    newLocation[k] = newLocation[k] < boundConstraint.get(k).getMin() ? boundConstraint.get(k).getMin() : newLocation[k];
                    newLocation[k] = newLocation[k] > boundConstraint.get(k).getMax() ? boundConstraint.get(k).getMax() : newLocation[k];
                }
                p.setLocation(newLocation);
                p.setFitness(function.Compute(newLocation));
                ++this.nEvals;
                if (p.getFitness() < p.getBestFitness()) {
                    p.setBestLocation(p.getLocation());
                    p.setBestFitness(p.getFitness());
                    if (p.getBestFitness() < this.minError) {
                        this.best = p.getBestLocation();
                        this.minError = p.getBestFitness();
                    }
                }
                this.swarm.set(j, p);
            }
            wf *= 0.99;
            if (this.listener == null) continue;
            this.listener.onIteration(i + 1, this.minError);
        }
    }

    private void Initialize(int swarmSize, List<DoubleRange> location, IObjectiveFunction function, long seed) {
        this.swarm = new ArrayList<Particle>(swarmSize);
        int size = location.size();
        if (seed != 0L) {
            this.random.setSeed(seed);
        }
        for (int i = 0; i < swarmSize; ++i) {
            double[] loc = new double[size];
            for (int j = 0; j < size; ++j) {
                DoubleRange range = location.get(j);
                loc[j] = range.getMin() + this.random.nextDouble() * (range.getMax() - range.getMin());
            }
            double[] vel = new double[size];
            Particle p = new Particle();
            p.setLocation(loc);
            p.setBestLocation(loc);
            p.setVelocity(vel);
            p.setFitness(function.Compute(loc));
            p.setBestFitness(p.getFitness());
            if (p.getFitness() < this.minError) {
                this.minError = p.getFitness();
                this.best = p.getLocation();
            }
            this.swarm.add(p);
        }
    }
}

