/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.Individual;
import Catalano.Math.Matrix;
import Catalano.Math.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class FireflyOptimization
extends BaseEvolutionaryOptimization {
    private double alpha = 0.2;
    private double beta0 = 2.0;
    private double gamma = 1.0;
    private double alphaDamp = 0.98;
    private double delta = 0.05;
    private double dmax;

    public double getMutationCoefficient() {
        return this.alpha;
    }

    public void setMutationCoefficient(double alpha) {
        this.alpha = alpha;
    }

    public double getAttractionCoefficient() {
        return this.beta0;
    }

    public void setAttractionCoefficient(double beta0) {
        this.beta0 = beta0;
    }

    public double getLightAbsorptionCoefficient() {
        return this.gamma;
    }

    public void setLightAbsorptionCoefficient(double gamma) {
        this.gamma = gamma;
    }

    public double getDampingRatio() {
        return this.alphaDamp;
    }

    public void setDampingRatio(double damp) {
        this.alphaDamp = damp;
    }

    public double getUniformMutationRatio() {
        return this.delta;
    }

    public void setUniformMutationRatio(double delta) {
        this.delta = delta;
    }

    public FireflyOptimization() {
        this(25, 1000);
    }

    public FireflyOptimization(int population, int generations) {
        this(population, generations, 0.2, 2.0, 1.0);
    }

    public FireflyOptimization(int population, int generations, double alpha, double beta0, double gamma) {
        this(population, generations, alpha, beta0, gamma, 0.98, 0.05);
    }

    public FireflyOptimization(int population, int generations, double alpha, double beta0, double gamma, double alphaDamp, double delta) {
        this.populationSize = population;
        this.generations = generations;
        this.beta0 = beta0;
        this.gamma = gamma;
        this.alphaDamp = alphaDamp;
        this.delta = delta;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        double damp = this.alpha;
        this.minError = Double.MAX_VALUE;
        this.nEvals = 0L;
        Random rand = new Random();
        List<Individual> pop = Individual.CreatePopulation(this.populationSize, boundConstraint, function);
        double[] min = new double[boundConstraint.size()];
        double[] max = new double[boundConstraint.size()];
        for (int i = 0; i < min.length; ++i) {
            DoubleRange range = boundConstraint.get(i);
            min[i] = range.getMin();
            max[i] = range.getMax();
        }
        this.dmax = Matrix.Norm2(Matrix.Subtract(min, max));
        for (int g = 0; g < this.generations; ++g) {
            int i;
            ArrayList<Individual> newPop = new ArrayList<Individual>(this.populationSize);
            for (i = 0; i < this.populationSize; ++i) {
                newPop.add(new Individual(null, Double.MAX_VALUE));
            }
            for (i = 0; i < this.populationSize; ++i) {
                for (int j = 0; j < this.populationSize; ++j) {
                    double rij = Matrix.Norm2(Matrix.Subtract(pop.get(i).getLocation(), pop.get(j).getLocation())) / this.dmax;
                    double beta = this.beta0 * Math.exp(-this.gamma * (rij * rij));
                    double[] e = Matrix.Multiply(Matrix.UniformRandom(-1.0, 1.0, boundConstraint.size()), this.delta);
                    double[] newsol = new double[boundConstraint.size()];
                    for (int k = 0; k < newsol.length; ++k) {
                        Individual a = pop.get(i);
                        Individual b = pop.get(j);
                        newsol[k] = a.getLocation()[k] + beta * rand.nextDouble() * (b.getLocation()[k] - a.getLocation()[k]) + damp * e[k];
                        newsol[k] = Tools.Clamp(newsol[k], boundConstraint.get(k));
                    }
                    double newfit = function.Compute(newsol);
                    ++this.nEvals;
                    if (!(newfit <= ((Individual)newPop.get(i)).getFitness())) continue;
                    newPop.set(i, new Individual(newsol, newfit));
                    if (!(newfit < this.minError)) continue;
                    this.minError = newfit;
                    this.best = Arrays.copyOf(((Individual)newPop.get(i)).getLocation(), boundConstraint.size());
                }
            }
            pop.addAll(newPop);
            Collections.sort(pop);
            pop = pop.subList(0, this.populationSize);
            damp *= this.alphaDamp;
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }
}

