/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Metaheuristics.Monoobjective;

import Catalano.Core.ArraysUtil;
import Catalano.Core.DoubleRange;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.BaseEvolutionaryOptimization;
import Catalano.Evolutionary.Metaheuristics.Monoobjective.IObjectiveFunction;
import Catalano.Math.Matrix;
import Catalano.Math.Random.Random;
import java.util.Arrays;
import java.util.List;

public class DifferentialEvolution
extends BaseEvolutionaryOptimization {
    private double f;
    private double f2;
    private float prob;
    private Strategy strategy;

    public double getF() {
        return this.f;
    }

    public void setF(double f) {
        this.f = f;
    }

    public float getCrossoverProbability() {
        return this.prob;
    }

    public void setCrossoverProbability(float prob) {
        this.prob = prob;
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(Strategy strategy) {
        this.strategy = strategy;
    }

    public DifferentialEvolution() {
        this(100, 1000);
    }

    public DifferentialEvolution(int population, int generations) {
        this(population, generations, 0.5);
    }

    public DifferentialEvolution(int population, int generations, double f) {
        this(population, generations, f, 0.85f);
    }

    public DifferentialEvolution(int population, int generations, double f, float prob) {
        this(population, generations, f, prob, Strategy.RAND_1_BIN);
    }

    public DifferentialEvolution(int population, int generations, double f, float prob, Strategy strategy) {
        this(population, generations, f, prob, strategy, f);
    }

    public DifferentialEvolution(int population, int generations, double f, float prob, Strategy strategy, double f2) {
        this.populationSize = population;
        this.generations = generations;
        this.f = f;
        this.prob = prob;
        this.strategy = strategy;
        this.f2 = f2;
    }

    @Override
    public void Compute(IObjectiveFunction function, List<DoubleRange> boundConstraint) {
        this.nEvals = 0L;
        this.minError = Double.MAX_VALUE;
        if (this.strategy == Strategy.RAND_1_BIN || this.strategy == Strategy.RAND_2_BIN || this.strategy == Strategy.RAND_1_EXP || this.strategy == Strategy.RAND_2_EXP) {
            this.Rand(function, boundConstraint, this.strategy);
        } else {
            this.Best(function, boundConstraint, this.strategy);
        }
    }

    private void Rand(IObjectiveFunction function, List<DoubleRange> boundConstraint, Strategy strategy) {
        Random rand = new Random();
        double[][] pop = new double[this.populationSize][boundConstraint.size()];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(boundConstraint);
        }
        double[] fitness = new double[pop.length];
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = function.Compute(pop[i]);
            if (!(fitness[i] < this.minError)) continue;
            this.minError = fitness[i];
            this.best = pop[i];
        }
        int[] idx = Matrix.Indices(0, pop.length);
        for (int g = 0; g < this.generations; ++g) {
            for (int p = 0; p < pop.length; ++p) {
                int i;
                int var = rand.nextInt(pop[0].length);
                double[] trial = new double[pop[0].length];
                switch (strategy) {
                    case RAND_1_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (i = 0; i < trial.length; ++i) {
                            trial[i] = rand.nextDouble() <= (double)this.prob || i == var ? pop[idx[0]][i] + this.f * (pop[idx[1]][i] - pop[idx[2]][i]) : pop[p][i];
                        }
                        break;
                    }
                    case RAND_2_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (int i2 = 0; i2 < trial.length; ++i2) {
                            trial[i2] = rand.nextDouble() <= (double)this.prob || i2 == var ? pop[idx[0]][i2] + this.f * (pop[idx[1]][i2] - pop[idx[2]][i2] + pop[idx[3]][i2] - pop[idx[4]][i2]) : pop[p][i2];
                        }
                    }
                    case RAND_1_EXP: {
                        int i3;
                        ArraysUtil.Shuffle(idx);
                        int l = 0;
                        double[] mv = Arrays.copyOf(pop[p], pop[0].length);
                        for (i3 = 0; i3 < trial.length; ++i3) {
                            mv[i3] = pop[idx[0]][i3] + this.f * (pop[idx[1]][i3] - pop[idx[2]][i3]);
                        }
                        trial = Arrays.copyOf(pop[p], pop[0].length);
                        do {
                            trial[var] = mv[var];
                            var = (var + 1) % pop[0].length;
                        } while (rand.nextDouble() <= (double)this.prob && ++l < pop[0].length);
                    }
                    case RAND_2_EXP: {
                        int i3;
                        ArraysUtil.Shuffle(idx);
                        int l = 0;
                        double[] mv = Arrays.copyOf(pop[p], pop[0].length);
                        for (i3 = 0; i3 < trial.length; ++i3) {
                            mv[i3] = pop[idx[0]][i3] + this.f * (pop[idx[1]][i3] - pop[idx[2]][i3] + pop[idx[3]][i3] - pop[idx[4]][i3]);
                        }
                        trial = Arrays.copyOf(pop[p], pop[0].length);
                        do {
                            trial[var] = mv[var];
                            var = (var + 1) % pop[0].length;
                        } while (rand.nextDouble() <= (double)this.prob && ++l < pop[0].length);
                    }
                }
                for (i = 0; i < trial.length; ++i) {
                    trial[i] = trial[i] < boundConstraint.get(i).getMin() ? boundConstraint.get(i).getMin() : trial[i];
                    trial[i] = trial[i] > boundConstraint.get(i).getMax() ? boundConstraint.get(i).getMax() : trial[i];
                }
                double fTrial = function.Compute(trial);
                ++this.nEvals;
                if (!(fTrial < fitness[p])) continue;
                pop[p] = trial;
                fitness[p] = fTrial;
                if (!(fTrial < this.minError)) continue;
                this.best = trial;
                this.minError = fTrial;
            }
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }

    private void Best(IObjectiveFunction function, List<DoubleRange> boundConstraint, Strategy strategy) {
        Random rand = new Random();
        double[][] pop = new double[this.populationSize][boundConstraint.size()];
        for (int i = 0; i < pop.length; ++i) {
            pop[i] = Matrix.UniformRandom(boundConstraint);
        }
        double[] fitness = new double[pop.length];
        for (int i = 0; i < fitness.length; ++i) {
            fitness[i] = function.Compute(pop[i]);
            if (!(fitness[i] < this.minError)) continue;
            this.minError = fitness[i];
            this.best = pop[i];
        }
        int[] idx = Matrix.Indices(0, pop.length);
        for (int g = 0; g < this.generations; ++g) {
            for (int p = 0; p < pop.length; ++p) {
                int i;
                int var = rand.nextInt(pop[0].length + 1);
                double[] trial = new double[pop[0].length];
                switch (strategy) {
                    case BEST_1_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (i = 0; i < trial.length; ++i) {
                            trial[i] = rand.nextDouble() <= (double)this.prob || i == var ? this.best[i] + this.f * (pop[idx[0]][i] - pop[idx[1]][i]) : pop[p][i];
                        }
                        break;
                    }
                    case BEST_2_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (int i2 = 0; i2 < trial.length; ++i2) {
                            trial[i2] = rand.nextDouble() <= (double)this.prob || i2 == var ? this.best[i2] + this.f * (pop[idx[0]][i2] - pop[idx[1]][i2] + pop[idx[2]][i2] - pop[idx[3]][i2]) : pop[p][i2];
                        }
                        break;
                    }
                    case BEST_1_EXP: {
                        int i3;
                        ArraysUtil.Shuffle(idx);
                        int l = 0;
                        double[] mv = Arrays.copyOf(pop[p], pop[0].length);
                        for (i3 = 0; i3 < trial.length; ++i3) {
                            mv[i3] = this.best[i3] + this.f * (pop[idx[0]][i3] - pop[idx[1]][i3]);
                        }
                        trial = Arrays.copyOf(pop[p], pop[0].length);
                        do {
                            trial[var] = mv[var];
                            var = (var + 1) % pop[0].length;
                        } while (rand.nextDouble() <= (double)this.prob && ++l < pop[0].length);
                        break;
                    }
                    case BEST_2_EXP: {
                        int i3;
                        ArraysUtil.Shuffle(idx);
                        int l = 0;
                        double[] mv = Arrays.copyOf(pop[p], pop[0].length);
                        for (i3 = 0; i3 < trial.length; ++i3) {
                            mv[i3] = this.best[i3] + this.f * (pop[idx[0]][i3] - pop[idx[1]][i3] + pop[idx[2]][i3] - pop[idx[3]][i3]);
                        }
                        trial = Arrays.copyOf(pop[p], pop[0].length);
                        do {
                            trial[var] = mv[var];
                            var = (var + 1) % pop[0].length;
                        } while (rand.nextDouble() <= (double)this.prob && ++l < pop[0].length);
                        break;
                    }
                    case RAND_TO_BEST_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (int i4 = 0; i4 < trial.length; ++i4) {
                            trial[i4] = rand.nextDouble() <= (double)this.prob || i4 == var ? pop[idx[1]][i4] + this.f * (pop[idx[2]][i4] - pop[idx[3]][i4]) + this.f2 * (this.best[i4] - pop[idx[0]][i4]) : pop[p][i4];
                        }
                        break;
                    }
                    case CURRENT_TO_BEST_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (int i5 = 0; i5 < trial.length; ++i5) {
                            trial[i5] = rand.nextDouble() <= (double)this.prob || i5 == var ? pop[p][i5] + this.f * (pop[idx[0]][i5] - pop[idx[1]][i5]) + this.f2 * (this.best[i5] - pop[p][i5]) : pop[p][i5];
                        }
                        break;
                    }
                    case CURRENT_TO_RAND_BIN: {
                        ArraysUtil.Shuffle(idx);
                        for (int i6 = 0; i6 < trial.length; ++i6) {
                            trial[i6] = rand.nextDouble() <= (double)this.prob || i6 == var ? pop[p][i6] + this.f * (pop[idx[1]][i6] - pop[idx[2]][i6]) + this.f2 * (pop[idx[0]][i6] - pop[p][i6]) : pop[p][i6];
                        }
                        break;
                    }
                }
                for (i = 0; i < trial.length; ++i) {
                    trial[i] = trial[i] < boundConstraint.get(i).getMin() ? boundConstraint.get(i).getMin() : trial[i];
                    trial[i] = trial[i] > boundConstraint.get(i).getMax() ? boundConstraint.get(i).getMax() : trial[i];
                }
                double fTrial = function.Compute(trial);
                ++this.nEvals;
                if (!(fTrial < fitness[p])) continue;
                pop[p] = trial;
                fitness[p] = fTrial;
                if (!(fTrial < this.minError)) continue;
                this.best = trial;
                this.minError = fTrial;
            }
            if (this.listener == null) continue;
            this.listener.onIteration(g + 1, this.minError);
        }
    }

    public static enum Strategy {
        RAND_1_BIN,
        RAND_2_BIN,
        RAND_1_EXP,
        RAND_2_EXP,
        BEST_1_BIN,
        BEST_2_BIN,
        BEST_1_EXP,
        BEST_2_EXP,
        RAND_TO_BEST_BIN,
        CURRENT_TO_BEST_BIN,
        CURRENT_TO_RAND_BIN;

    }
}

