/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Reinsertion;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Population;
import Catalano.Evolutionary.Genetic.Reinsertion.IReinsertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PartialElitismReinsertion
implements IReinsertion {
    private float percentage;

    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float percentage) {
        this.percentage = percentage;
    }

    public PartialElitismReinsertion() {
        this(0.15f);
    }

    public PartialElitismReinsertion(float percentage) {
        this.percentage = percentage;
    }

    @Override
    public List<IChromosome> Compute(Population pop, List<IChromosome> oldPop, List<IChromosome> newPop) {
        this.Sort(oldPop);
        this.Sort(newPop);
        ArrayList<IChromosome> p = new ArrayList<IChromosome>();
        int n = (int)((float)oldPop.size() * this.percentage);
        p.addAll(oldPop.subList(0, n));
        int diff = pop.getPopulationSize() - p.size();
        p.addAll(newPop.subList(0, diff));
        return p;
    }

    private void Sort(List<IChromosome> list) {
        Collections.sort(list, new Comparator<IChromosome>(){

            @Override
            public int compare(IChromosome o1, IChromosome o2) {
                return Double.compare(o2.getFitness(), o1.getFitness());
            }
        });
    }
}

