/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Mutation;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Mutation.IMutation;
import java.util.Random;

public class SwapMutation
implements IMutation<IChromosome> {
    private float probability;

    public float getProbability() {
        return this.probability;
    }

    public void setProbability(float probability) {
        this.probability = probability;
    }

    public SwapMutation() {
    }

    public SwapMutation(float probability) {
        this.probability = probability;
    }

    @Override
    public IChromosome Compute(IChromosome chromossome) {
        Random rand = new Random();
        IChromosome c = chromossome.Clone();
        if (this.probability == 0.0f) {
            int indexA = rand.nextInt(c.getLength());
            int indexB = rand.nextInt(c.getLength());
            Object t1 = c.getGene(indexA);
            Object t2 = c.getGene(indexB);
            c.setGene(indexA, t2);
            c.setGene(indexB, t1);
        } else {
            for (int i = 0; i < c.getLength(); ++i) {
                if (!(rand.nextFloat() <= this.probability)) continue;
                int indexA = rand.nextInt(c.getLength());
                int indexB = rand.nextInt(c.getLength());
                Object t1 = c.getGene(indexA);
                Object t2 = c.getGene(indexB);
                c.setGene(indexA, t2);
                c.setGene(indexB, t1);
            }
        }
        return c;
    }
}

