/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Evolutionary.Genetic.Chromosome.IChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class PartiallyMappedCrossover
implements ICrossover<IChromosome> {
    @Override
    public List<IChromosome> Compute(IChromosome chromosome1, IChromosome chromosome2) {
        int i;
        Random rand = new Random();
        int length = chromosome1.getLength();
        int[] cuts = new int[]{rand.nextInt(length), rand.nextInt(length)};
        Arrays.sort(cuts, 0, cuts.length);
        IChromosome c1 = chromosome1.Clone();
        IChromosome c2 = chromosome2.Clone();
        Object[] v1 = new Object[length - (cuts[1] - cuts[0]) - 1];
        Object[] v2 = new Object[length - (cuts[1] - cuts[0]) - 1];
        int index = 0;
        for (i = 0; i < length; ++i) {
            if (i >= cuts[0] && i <= cuts[1]) continue;
            v1[index] = chromosome1.getGene(i);
            v2[index] = chromosome2.getGene(i);
            ++index;
        }
        index = 0;
        for (i = 0; i < length; ++i) {
            if (i >= cuts[0] && i <= cuts[1]) continue;
            c1.setGene(i, v1[index]);
            c2.setGene(i, v2[index]);
            ++index;
        }
        ArrayList<IChromosome> lst = new ArrayList<IChromosome>(2);
        lst.add(c1);
        lst.add(c2);
        return lst;
    }
}

