/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Evolutionary.Genetic.Crossover;

import Catalano.Core.ArraysUtil;
import Catalano.Evolutionary.Genetic.Chromosome.PermutationChromosome;
import Catalano.Evolutionary.Genetic.Crossover.ICrossover;
import Catalano.Math.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class OrderCrossover
implements ICrossover<PermutationChromosome> {
    @Override
    public List<PermutationChromosome> Compute(PermutationChromosome chromosome1, PermutationChromosome chromosome2) {
        int e;
        int i;
        Random rand = new Random();
        int length = chromosome1.getLength();
        int[] cuts = new int[]{rand.nextInt(length), rand.nextInt(length)};
        Arrays.sort(cuts, 0, cuts.length);
        int[] c1 = Matrix.CreateMatrix1D(length, -1);
        int[] c2 = Matrix.CreateMatrix1D(length, -1);
        for (i = 0; i < length; ++i) {
            e = (Integer)chromosome1.getGene(i);
            if (i < cuts[0] || i > cuts[1]) continue;
            c1[i] = e;
        }
        int idx = 0;
        int[] order = this.empty(c1);
        for (i = 0; i < length; ++i) {
            e = (Integer)chromosome2.getGene(i);
            if (ArraysUtil.Contains(c1, e)) continue;
            c1[order[idx++]] = e;
        }
        for (i = 0; i < length; ++i) {
            e = (Integer)chromosome2.getGene(i);
            if (i < cuts[0] || i > cuts[1]) continue;
            c2[i] = e;
        }
        idx = 0;
        order = this.empty(c2);
        for (i = 0; i < length; ++i) {
            e = (Integer)chromosome1.getGene(i);
            if (ArraysUtil.Contains(c2, e)) continue;
            c2[order[idx++]] = e;
        }
        ArrayList<PermutationChromosome> lst = new ArrayList<PermutationChromosome>(2);
        lst.add(new PermutationChromosome(c1));
        lst.add(new PermutationChromosome(c2));
        return lst;
    }

    private int[] empty(int[] array) {
        int c = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != -1) continue;
            ++c;
        }
        int[] order = new int[c];
        int idx = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != -1) continue;
            order[idx++] = i;
        }
        return order;
    }
}

