/*
 * Decompiled with CFR 0.152.
 */
package Catalano.Core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;

public class ArraysUtil {
    private ArraysUtil() {
    }

    public static int[] Argsort(final double[] array, final boolean ascending) {
        Number[] indexes = new Integer[array.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return (ascending ? 1 : -1) * Double.compare(array[i1], array[i2]);
            }
        });
        return ArraysUtil.asArray((Number[])indexes);
    }

    public static int[] Argsort(final int[] array, final boolean ascending) {
        Number[] indexes = new Integer[array.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return (ascending ? 1 : -1) * Integer.compare(array[i1], array[i2]);
            }
        });
        return ArraysUtil.asArray((Number[])indexes);
    }

    public static int[] Argsort(final float[] array, final boolean ascending) {
        Number[] indexes = new Integer[array.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return (ascending ? 1 : -1) * Float.compare(array[i1], array[i2]);
            }
        });
        return ArraysUtil.asArray((Number[])indexes);
    }

    public static boolean Contains(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    public static int[] Concatenate(int[] array, int[] array2) {
        int i;
        int[] all = new int[array.length + array2.length];
        int idx = 0;
        for (i = 0; i < array.length; ++i) {
            all[idx++] = array[i];
        }
        for (i = 0; i < array2.length; ++i) {
            all[idx++] = array2[i];
        }
        return all;
    }

    public static double[] Concatenate(double[] array, double[] array2) {
        int i;
        double[] all = new double[array.length + array2.length];
        int idx = 0;
        for (i = 0; i < array.length; ++i) {
            all[idx++] = array[i];
        }
        for (i = 0; i < array2.length; ++i) {
            all[idx++] = array2[i];
        }
        return all;
    }

    public static float[] Concatenate(float[] array, float[] array2) {
        int i;
        float[] all = new float[array.length + array2.length];
        int idx = 0;
        for (i = 0; i < array.length; ++i) {
            all[idx++] = array[i];
        }
        for (i = 0; i < array2.length; ++i) {
            all[idx++] = array2[i];
        }
        return all;
    }

    public static int[] ConcatenateInt(List<int[]> arrays) {
        int size = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            size += arrays.get(i).length;
        }
        int[] all = new int[size];
        int idx = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            int[] v = arrays.get(i);
            for (int j = 0; j < v.length; ++j) {
                all[idx++] = v[i];
            }
        }
        return all;
    }

    public static double[] ConcatenateDouble(List<double[]> arrays) {
        int size = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            size += arrays.get(i).length;
        }
        double[] all = new double[size];
        int idx = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            double[] v = arrays.get(i);
            for (int j = 0; j < v.length; ++j) {
                all[idx++] = v[i];
            }
        }
        return all;
    }

    public static float[] ConcatenateFloat(List<float[]> arrays) {
        int size = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            size += arrays.get(i).length;
        }
        float[] all = new float[size];
        int idx = 0;
        for (int i = 0; i < arrays.size(); ++i) {
            float[] v = arrays.get(i);
            for (int j = 0; j < v.length; ++j) {
                all[idx++] = v[i];
            }
        }
        return all;
    }

    public static <T extends Number> int[] asArray(T ... array) {
        int[] b = new int[array.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = ((Number)array[i]).intValue();
        }
        return b;
    }

    public static void Shuffle(double[] array) {
        ArraysUtil.Shuffle(array, 0L);
    }

    public static void Shuffle(double[] array, long seed) {
        Random random = new Random();
        if (seed != 0L) {
            random.setSeed(seed);
        }
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            double temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public static void Shuffle(int[] array) {
        ArraysUtil.Shuffle(array, 0L);
    }

    public static void Shuffle(int[] array, long seed) {
        Random random = new Random();
        if (seed != 0L) {
            random.setSeed(seed);
        }
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            int temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public static void Shuffle(float[] array) {
        ArraysUtil.Shuffle(array, 0L);
    }

    public static void Shuffle(float[] array, long seed) {
        Random random = new Random();
        if (seed != 0L) {
            random.setSeed(seed);
        }
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            float temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public static <T> void Shuffle(T[] array) {
        ArraysUtil.Shuffle(array, 0L);
    }

    public static <T> void Shuffle(T[] array, long seed) {
        Random random = new Random();
        if (seed != 0L) {
            random.setSeed(seed);
        }
        for (int i = array.length - 1; i > 0; --i) {
            int index = random.nextInt(i + 1);
            T temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    public static float[] toFloat(int[] array) {
        float[] n = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            n[i] = array[i];
        }
        return n;
    }

    public static float[][] toFloat(int[][] array) {
        float[][] n = new float[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                n[i][j] = array[i][j];
            }
        }
        return n;
    }

    public static float[] toFloat(double[] array) {
        float[] n = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            n[i] = (float)array[i];
        }
        return n;
    }

    public static float[][] toFloat(double[][] array) {
        float[][] n = new float[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                n[i][j] = (float)array[i][j];
            }
        }
        return n;
    }

    public static float[] toFloat(List<Float> ints) {
        float[] n = new float[ints.size()];
        for (int i = 0; i < n.length; ++i) {
            n[i] = ints.get(i).floatValue();
        }
        return n;
    }

    public static int[] toInt(double[] array) {
        int[] n = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            n[i] = (int)array[i];
        }
        return n;
    }

    public static int[][] toInt(double[][] array) {
        int[][] n = new int[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                n[i][j] = (int)array[i][j];
            }
        }
        return n;
    }

    public static int[] toInt(List<Integer> ints) {
        int[] n = new int[ints.size()];
        for (int i = 0; i < n.length; ++i) {
            n[i] = ints.get(i);
        }
        return n;
    }

    public static int[] toInt(float[] array) {
        int[] n = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            n[i] = (int)array[i];
        }
        return n;
    }

    public static int[][] toInt(float[][] array) {
        int[][] n = new int[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                n[i][j] = (int)array[i][j];
            }
        }
        return n;
    }

    public static double[] toDouble(int[] array) {
        double[] n = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            n[i] = array[i];
        }
        return n;
    }

    public static double[][] toDouble(int[][] array) {
        double[][] n = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                n[i][j] = array[i][j];
            }
        }
        return n;
    }

    public static double[] toDouble(float[] array) {
        double[] n = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            n[i] = array[i];
        }
        return n;
    }

    public static double[][] toDouble(float[][] array) {
        double[][] n = new double[array.length][array[0].length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[0].length; ++j) {
                n[i][j] = array[i][j];
            }
        }
        return n;
    }

    public static double[] toDouble(List<Double> ints) {
        double[] n = new double[ints.size()];
        for (int i = 0; i < n.length; ++i) {
            n[i] = ints.get(i);
        }
        return n;
    }
}

