/*
 * Decompiled with CFR 0.152.
 */
package info.clearthought.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class SingleFiledLayout
implements LayoutManager,
Serializable {
    public static final int COLUMN = 0;
    public static final int ROW = 1;
    public static final int LEFT = 0;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int FULL = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static int DEFAULT_GAP = 5;
    protected int orientation;
    protected int justification;
    protected int gap;

    public SingleFiledLayout() {
        this(0, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int n) {
        this(n, 0, DEFAULT_GAP);
    }

    public SingleFiledLayout(int n, int n2, int n3) {
        if (n != 1) {
            n = 0;
        }
        if (n2 != 1 && n2 != 2 && n2 != 4) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        this.orientation = n;
        this.justification = n2;
        this.gap = n3;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            int n3 = 0;
            while (n3 < componentArray.length) {
                Dimension dimension2 = componentArray[n3].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        n = insets.left;
                        break;
                    }
                    case 1: {
                        n = (dimension.width - dimension2.width >> 1) + insets.left - insets.right;
                        break;
                    }
                    case 2: {
                        n = insets.left;
                        dimension2.width = dimension.width - insets.left - insets.right;
                        break;
                    }
                    case 4: {
                        n = dimension.width - dimension2.width - insets.right;
                    }
                }
                componentArray[n3].setBounds(n, n2, dimension2.width, dimension2.height);
                n2 += dimension2.height + this.gap;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < componentArray.length) {
                Dimension dimension3 = componentArray[n4].getPreferredSize();
                switch (this.justification) {
                    case 0: {
                        n2 = insets.top;
                        break;
                    }
                    case 1: {
                        n2 = (dimension.height - dimension3.height >> 1) + insets.top - insets.bottom;
                        break;
                    }
                    case 2: {
                        n2 = insets.top;
                        dimension3.height = dimension.height - insets.top - insets.bottom;
                        break;
                    }
                    case 3: {
                        n2 = dimension.height - dimension3.height - insets.bottom;
                    }
                }
                componentArray[n4].setBounds(n, n2, dimension3.width, dimension3.height);
                n += dimension3.width + this.gap;
                ++n4;
            }
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        int n;
        int n2 = 0;
        int n3 = 0;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            n = 0;
            while (n < componentArray.length) {
                Dimension dimension = componentArray[n].getPreferredSize();
                if (n2 < dimension.width) {
                    n2 = dimension.width;
                }
                n3 += dimension.height + this.gap;
                ++n;
            }
            n3 -= this.gap;
        } else {
            n = 0;
            while (n < componentArray.length) {
                Dimension dimension = componentArray[n].getPreferredSize();
                n2 += dimension.width + this.gap;
                if (n3 < dimension.height) {
                    n3 = dimension.height;
                }
                ++n;
            }
            n2 -= this.gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n2 += insets.left + insets.right, n3 += insets.top + insets.bottom);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n;
        int n2 = 0;
        int n3 = 0;
        Component[] componentArray = container.getComponents();
        if (this.orientation == 0) {
            n = 0;
            while (n < componentArray.length) {
                Dimension dimension = componentArray[n].getMinimumSize();
                if (n2 < dimension.width) {
                    n2 = dimension.width;
                }
                n3 += dimension.height + this.gap;
                ++n;
            }
            n3 -= this.gap;
        } else {
            n = 0;
            while (n < componentArray.length) {
                Dimension dimension = componentArray[n].getMinimumSize();
                n2 += dimension.width + this.gap;
                if (n3 < dimension.height) {
                    n3 = dimension.height;
                }
                ++n;
            }
            n2 = -this.gap;
        }
        Insets insets = container.getInsets();
        return new Dimension(n2 += insets.left + insets.right, n3 += insets.top + insets.bottom);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

