/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.ITracePointProvider;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.views.ChartPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class MultiAxesStaticChart
extends JPanel {
    private static final long serialVersionUID = 3476998470009995195L;

    public static void main(String[] args) {
        for (int i = 0; i < 1; ++i) {
            JFrame frame = new JFrame(MultiAxesStaticChart.class.getName());
            frame.getContentPane().add(new MultiAxesStaticChart());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.setSize(600, 600);
            frame.setLocation(i % 3 * 200, i / 3 * 100);
            frame.setVisible(true);
        }
    }

    private MultiAxesStaticChart() {
        ITracePoint2D copyPoint;
        int i;
        this.setLayout(new BorderLayout());
        Chart2D chart = new Chart2D();
        chart.setToolTipType(Chart2D.ToolTipType.VALUE_SNAP_TO_TRACEPOINTS);
        ITracePointProvider pointCreator = chart.getTracePointProvider();
        Trace2DSimple apples = new Trace2DSimple();
        apples.setColor(Color.RED);
        apples.setName("Apples");
        Trace2DSimple pears = new Trace2DSimple();
        pears.setColor(Color.BLUE);
        pears.setName("Pears");
        Trace2DSimple carrots = new Trace2DSimple();
        carrots.setColor(Color.MAGENTA);
        carrots.setName("Carrots");
        AxisLinear yAxisApples = new AxisLinear();
        yAxisApples.getAxisTitle().setTitle("Y-Apples");
        yAxisApples.getAxisTitle().setTitleColor(Color.RED);
        AxisLinear yAxisPears = new AxisLinear();
        yAxisPears.getAxisTitle().setTitle("Y-Pears");
        yAxisPears.getAxisTitle().setTitleColor(Color.BLUE);
        AxisLinear yAxisCarrots = new AxisLinear();
        yAxisCarrots.getAxisTitle().setTitle("Y-Carrots");
        yAxisCarrots.getAxisTitle().setTitleColor(Color.MAGENTA);
        chart.setAxisYLeft(yAxisApples, 0);
        chart.setAxisYRight(yAxisPears, 0);
        chart.addAxisYLeft(yAxisCarrots);
        AxisLinear xAxisApples = new AxisLinear();
        xAxisApples.getAxisTitle().setTitle("X-Apples");
        xAxisApples.getAxisTitle().setTitleColor(Color.RED);
        AxisLinear xAxisPears = new AxisLinear();
        xAxisPears.getAxisTitle().setTitle("X-Pears");
        xAxisPears.getAxisTitle().setTitleColor(Color.BLUE);
        AxisLinear xAxisCarrots = new AxisLinear();
        xAxisCarrots.getAxisTitle().setTitle("X-Carrots");
        xAxisCarrots.getAxisTitle().setTitleColor(Color.MAGENTA);
        chart.setAxisXBottom(xAxisApples, 0);
        chart.setAxisXTop(xAxisPears, 0);
        chart.addAxisXBottom(xAxisCarrots);
        chart.addTrace(apples, xAxisApples, yAxisApples);
        chart.addTrace(pears, xAxisPears, yAxisPears);
        chart.addTrace(carrots, xAxisCarrots, yAxisCarrots);
        double time = System.currentTimeMillis();
        for (i = 0; i < 120; ++i) {
            apples.addPoint(pointCreator.createTracePoint(time + (double)(i * 10000), (10.0 + Math.random()) * (double)i));
        }
        Iterator<ITracePoint2D> it = apples.iterator();
        i = 0;
        while (it.hasNext()) {
            copyPoint = it.next();
            pears.addPoint(pointCreator.createTracePoint((double)i * 0.001, copyPoint.getY() + Math.random() * 1000.0));
            ++i;
        }
        it = apples.iterator();
        i = 0;
        while (it.hasNext()) {
            copyPoint = it.next();
            carrots.addPoint(pointCreator.createTracePoint(i * 100, 100.0 - copyPoint.getY()));
            ++i;
        }
        this.add((Component)new ChartPanel(chart), "Center");
    }
}

