/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.twoSample.controlMedianTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.tests.StatisticalTest;
import javanpst.utils.Operations;

public class ControlMedianTest
extends StatisticalTest {
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int n;
    private int m;
    private int r;
    private double medianValue;
    private double medianValue2;
    private int u;
    private int v;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public ControlMedianTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.r = 0;
        this.u = 0;
        this.v = 0;
        this.sample1 = null;
        this.sample2 = null;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public ControlMedianTest(DataTable newData) {
        this.setReportFormat();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Median test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.sample1 = new double[this.data.getRows() - nulls];
        nulls = this.data.getColumnNulls(1);
        this.sample2 = new double[this.data.getRows() - nulls];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        int i;
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Median test only can be employed with two samples");
            this.clearData();
            return;
        }
        for (i = 0; i < this.data.getColumns(); ++i) {
            if (this.data.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.sample1 = new double[this.data.getRows() - nulls];
        nulls = this.data.getColumnNulls(1);
        this.sample2 = new double[this.data.getRows() - nulls];
        int counter1 = 0;
        int counter2 = 0;
        for (i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int medianRank;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        if (this.sample2.length % 2 == 0) {
            medianRank = this.sample2.length / 2;
            this.medianValue2 = (this.sample2[medianRank - 1] + this.sample2[medianRank]) / 2.0;
            this.r = this.sample2.length / 2;
        } else {
            medianRank = (this.sample2.length + 1) / 2;
            this.medianValue2 = this.sample2[medianRank - 1];
            this.r = (this.sample2.length - 1) / 2;
        }
        if (this.sample1.length % 2 == 0) {
            medianRank = this.sample1.length / 2;
            this.medianValue = (this.sample1[medianRank - 1] + this.sample1[medianRank]) / 2.0;
        } else {
            medianRank = (this.sample1.length + 1) / 2;
            this.medianValue = this.sample1[medianRank - 1];
        }
        this.n = this.sample2.length;
        this.m = this.sample1.length;
        this.u = 0;
        while (this.sample1[this.u] < this.medianValue) {
            ++this.u;
        }
        this.v = 0;
        while (this.sample1[this.v] < this.medianValue2) {
            ++this.v;
        }
        this.computeStatistics();
        this.performed = true;
    }

    private void computeStatistics() {
        int i;
        double denominator = Operations.combinatorial(this.m + 2 * this.r + 1, this.m);
        double numerator = 0.0;
        double numerator2 = 0.0;
        for (i = 0; i <= this.v; ++i) {
            numerator += Operations.combinatorial(this.m + this.r - i, this.m - i) * Operations.combinatorial(i + this.r, i);
        }
        this.exactLeftTail = numerator / denominator;
        for (i = 0; i >= this.v; ++i) {
            numerator2 += Operations.combinatorial(this.m + this.r - i, this.m - i) * Operations.combinatorial(i + this.r, i);
        }
        this.exactRightTail = numerator / denominator;
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        NormalDistribution normal = new NormalDistribution();
        denominator = Math.sqrt((double)this.m * (double)(this.m + this.n));
        numerator = Math.sqrt(this.n) * (double)(2 * this.v - this.m + 1);
        this.asymptoticLeftTail = normal.getTipifiedProbability(numerator / denominator, false);
        numerator = Math.sqrt(this.n) * (double)(2 * this.u - this.m + 1);
        this.asymptoticRightTail = normal.getTipifiedProbability(numerator / denominator, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
    }

    public double getU() {
        return this.u;
    }

    public double getV() {
        return this.v;
    }

    public double getMedian() {
        return this.medianValue;
    }

    public double getMedian2() {
        return this.medianValue2;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Control Median test for 2 independent samples\n";
        report = report + "***************************************\n\n";
        report = report + "Median value of sample 1: " + this.nf6.format(this.medianValue) + "\n";
        report = report + "Median value of sample 2: " + this.nf6.format(this.medianValue) + "\n";
        report = report + "U statistic: " + this.nf6.format(this.u) + "\n";
        report = report + "V statistic: " + this.nf6.format(this.v) + "\n\n";
        report = report + "Exact P-Value (Left tail, Y > X): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Y < X): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Y != X): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Y > X): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Y > X): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Y != X): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

