/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.scale.siegel_TukeyTest;

import java.util.Arrays;
import javanpst.data.structures.dataTable.DataTable;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.tests.WilcoxonRankSumDistribution;
import javanpst.tests.StatisticalTest;

public class Siegel_TukeyTest
extends StatisticalTest {
    private WilcoxonRankSumDistribution distribution;
    private DataTable data;
    private double[] sample1;
    private double[] sample2;
    private int values1;
    private int values2;
    private double[] combined;
    private int N;
    private int[] weights;
    private double sumWeights;
    private double ST1;
    private double ST2;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public Siegel_TukeyTest() {
        this.distribution = WilcoxonRankSumDistribution.getInstance();
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.data = new DataTable();
        this.performed = false;
        this.dataReady = false;
        this.ST1 = 0.0;
        this.ST2 = 0.0;
        this.sample1 = null;
        this.sample2 = null;
        this.weights = null;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public Siegel_TukeyTest(DataTable newData) {
        this.setReportFormat();
        this.distribution = WilcoxonRankSumDistribution.getInstance();
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Siegel-Tukey test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        this.data = DataTable.newInstance(newData);
        if (this.data.getColumns() != 2) {
            System.out.println("Siegel-Tukey test only can be employed with two samples");
            this.clearData();
            return;
        }
        int nulls = this.data.getColumnNulls(0);
        this.values1 = this.data.getRows() - nulls;
        this.sample1 = new double[this.values1];
        nulls = this.data.getColumnNulls(1);
        this.values2 = this.data.getRows() - nulls;
        this.sample2 = new double[this.values2];
        int counter1 = 0;
        int counter2 = 0;
        for (int i = 0; i < this.data.getRows(); ++i) {
            double value = this.data.get(i, 0);
            if (value != Double.MIN_VALUE) {
                this.sample1[counter1] = value;
                ++counter1;
            }
            if ((value = this.data.get(i, 1)) == Double.MIN_VALUE) continue;
            this.sample2[counter2] = value;
            ++counter2;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        int pointer;
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.combined = new double[this.sample1.length + this.sample2.length];
        Arrays.sort(this.sample1);
        Arrays.sort(this.sample2);
        System.arraycopy(this.sample1, 0, this.combined, 0, this.sample1.length);
        System.arraycopy(this.sample2, 0, this.combined, this.sample1.length, this.sample2.length);
        Arrays.sort(this.combined);
        this.N = this.sample1.length + this.sample2.length;
        this.weights = new int[this.N];
        this.generateWeights();
        this.ST1 = 0.0;
        int pointer2 = 0;
        if (this.values1 <= this.values2) {
            for (pointer = 0; pointer < this.sample1.length; ++pointer) {
                while (this.combined[pointer2] != this.sample1[pointer]) {
                    ++pointer2;
                }
                this.ST1 += (double)this.weights[pointer2];
            }
            this.ST2 = this.sumWeights - this.ST1;
            this.computePValues();
        } else {
            while (pointer < this.sample2.length) {
                while (this.combined[pointer2] != this.sample2[pointer]) {
                    ++pointer2;
                }
                this.ST1 += (double)this.weights[pointer2];
                ++pointer;
            }
            this.ST2 = this.sumWeights - this.ST1;
            this.computePValues();
        }
        this.performed = true;
    }

    private void generateWeights() {
        this.sumWeights = 0.0;
        boolean even = this.N % 2 == 0;
        for (int i = 1; i <= this.N; ++i) {
            int value = even ? (i <= this.N / 2 ? (i % 2 == 0 ? 2 * i : 2 * i - 1) : (i % 2 == 0 ? 2 * (this.N - i) + 2 : 2 * (this.N - i) + 1)) : (i <= this.N / 2 ? (i % 2 == 0 ? 2 * i : 2 * i - 1) : (i == this.N / 2 + 1 ? 0 : (i % 2 == 0 ? 2 * (this.N - i) + 2 : 2 * (this.N - i) + 1)));
            this.weights[i - 1] = value;
            this.sumWeights += (double)value;
        }
    }

    private void computePValues() {
        NormalDistribution normal = new NormalDistribution();
        if (this.values1 <= 10 && this.values2 <= 10) {
            this.exactLeftTail = this.distribution.computeLeftProbability(this.values2, this.values1, (int)this.ST1);
            this.exactRightTail = this.distribution.computeRightProbability(this.values2, this.values1, (int)this.ST1);
            if (this.exactLeftTail == -1.0) {
                this.exactLeftTail = 1.0 - this.exactRightTail;
            }
            if (this.exactRightTail == -1.0) {
                this.exactRightTail = 1.0 - this.exactLeftTail;
            }
            this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        }
        double denominator = (double)(this.values1 * this.values2 * (this.values1 + this.values2 + 1)) / 12.0;
        denominator = Math.sqrt(denominator);
        double numerator = this.ST1 - 0.5 - (double)this.values1 * ((double)this.values2 + (double)this.values1 + 1.0) / 2.0;
        double z = numerator / denominator;
        this.asymptoticRightTail = 1.0 - normal.getTipifiedProbability(z, false);
        numerator = this.ST1 + 0.5 - (double)this.values1 * ((double)this.values2 + (double)this.values1 + 1.0) / 2.0;
        z = numerator / denominator;
        this.asymptoticLeftTail = normal.getTipifiedProbability(z, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
    }

    public double getTestStatistic1() {
        return this.ST1;
    }

    public double getTestStatistic2() {
        return this.ST2;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    public String printWeights() {
        String text = "";
        for (int i = 0; i < this.weights.length; ++i) {
            text = text + this.weights[i] + " ";
        }
        return text;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.data;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************\n";
        report = report + "Siegel-Tukey test\n";
        report = report + "**************\n\n";
        report = report + "Siegel-Tukey Statistic X: " + this.nf6.format(this.ST1) + "\n";
        report = report + "Siegel-Tukey Statistic Y: " + this.nf6.format(this.ST2) + "\n\n";
        report = report + "Exact P-Value (Left tail): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

