/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.randomness.numberRunsTest;

import javanpst.data.structures.sequence.StringSequence;
import javanpst.distributions.tests.TotalNumberOfRunsDistribution;
import javanpst.tests.StatisticalTest;

public class NumberRunsTest
extends StatisticalTest {
    private TotalNumberOfRunsDistribution distribution = TotalNumberOfRunsDistribution.getInstance();
    private StringSequence sequence;
    private int n1;
    private int n2;
    private int runs;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public NumberRunsTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.sequence = new StringSequence();
        this.performed = false;
        this.dataReady = false;
        this.n1 = 0;
        this.n2 = 0;
        this.runs = 0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
    }

    public NumberRunsTest(StringSequence newSequence) {
        this.setReportFormat();
        this.sequence = new StringSequence(newSequence);
        if (!this.sequence.isBinary()) {
            System.out.println("Total number of runs test only can be employed with binary sequences");
            this.clearData();
            return;
        }
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(StringSequence newSequence) {
        this.sequence = new StringSequence(newSequence);
        if (!this.sequence.isBinary()) {
            System.out.println("Total number of runs test only can be employed with binary sequences");
            this.clearData();
            return;
        }
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.countElements();
        this.runs = 1;
        String c = this.sequence.get(0);
        for (int i = 1; i < this.sequence.size(); ++i) {
            if (this.sequence.get(i).equals(c)) continue;
            ++this.runs;
            c = this.sequence.get(i);
        }
        this.exactLeftTail = this.distribution.computeLeftTailProbability(this.n1, this.n2, this.runs);
        this.exactRightTail = this.distribution.computeRightTailProbability(this.n1, this.n2, this.runs);
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        this.asymptoticLeftTail = this.distribution.computeAsymptoticLeftTailProbability(this.n1, this.n2, this.runs);
        this.asymptoticRightTail = this.distribution.computeAsymptoticRightTailProbability(this.n1, this.n2, this.runs);
        this.asymptoticDoubleTail = this.distribution.computeAsymptoticDoubleTailProbability(this.n1, this.n2, this.runs);
        this.performed = true;
    }

    private void countElements() {
        this.n1 = 0;
        this.n2 = 0;
        String firstElement = this.sequence.get(0);
        for (String d : this.sequence.getSequence()) {
            if (d.equals(firstElement)) {
                ++this.n1;
                continue;
            }
            ++this.n2;
        }
        if (this.n1 > this.n2) {
            int aux = this.n1;
            this.n1 = this.n2;
            this.n2 = aux;
        }
    }

    public double getN1() {
        return this.n1;
    }

    public double getN2() {
        return this.n2;
    }

    public double getRuns() {
        return this.runs;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n************************\n";
        report = report + "Total number of runs test\n";
        report = report + "**************************\n\n";
        report = report + "Number of elements - N1: " + this.nf6.format(this.n1) + " N2: " + this.nf6.format(this.n2) + "\n";
        report = report + "Number of runs: " + this.nf6.format(this.runs) + "\n\n";
        report = report + "Exact P-Value (Left tail, Too few runs): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Too many runs): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Non randomness): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Too few runs): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Too many runs): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Non randomness): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

