/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.oneSample.signTest;

import javanpst.data.structures.dataTable.DataTable;
import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.common.continuous.NormalDistribution;
import javanpst.distributions.common.discrete.BinomialDistribution;
import javanpst.tests.StatisticalTest;

public class SignTest
extends StatisticalTest {
    private NumericSequence sequence;
    private BinomialDistribution binomial;
    private NormalDistribution normal;
    private double K;
    private double K2;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;
    private double asymptoticLeftTail;
    private double asymptoticRightTail;
    private double asymptoticDoubleTail;

    public SignTest() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.K = 0.0;
        this.K2 = 0.0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.asymptoticLeftTail = -1.0;
        this.asymptoticRightTail = -1.0;
        this.asymptoticDoubleTail = -1.0;
        this.sequence = new NumericSequence();
        this.dataReady = false;
        this.performed = false;
    }

    public SignTest(NumericSequence newSequence) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.binomial = new BinomialDistribution();
        this.normal = new NormalDistribution();
        this.binomial.setP(0.5);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(NumericSequence newSequence) {
        this.sequence = new NumericSequence(newSequence);
        this.binomial = new BinomialDistribution();
        this.normal = new NormalDistribution();
        this.binomial.setP(0.5);
        this.dataReady = true;
        this.performed = false;
    }

    public SignTest(DataTable newData) {
        this.setReportFormat();
        if (newData.getColumns() != 2) {
            System.out.println("Sign test only can be employed with two samples");
            this.clearData();
            return;
        }
        for (int i = 0; i < newData.getColumns(); ++i) {
            if (newData.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        double[] differences = new double[newData.getRows()];
        for (int i = 0; i < differences.length; ++i) {
            differences[i] = newData.get(i, 0) - newData.get(i, 1);
        }
        this.sequence = new NumericSequence(differences);
        this.binomial = new BinomialDistribution();
        this.normal = new NormalDistribution();
        this.binomial.setP(0.5);
        this.dataReady = true;
        this.performed = false;
    }

    public void setData(DataTable newData) {
        if (newData.getColumns() != 2) {
            System.out.println("Sign test only can be employed with two samples");
            this.clearData();
            return;
        }
        for (int i = 0; i < newData.getColumns(); ++i) {
            if (newData.getColumnNulls(i) <= 0) continue;
            System.out.println("No null values allowed in this test.");
            this.clearData();
            return;
        }
        double[] differences = new double[newData.getRows()];
        for (int i = 0; i < differences.length; ++i) {
            differences[i] = newData.get(i, 0) - newData.get(i, 1);
        }
        this.sequence = new NumericSequence(differences);
        this.binomial = new BinomialDistribution();
        this.normal = new NormalDistribution();
        this.binomial.setP(0.5);
        this.dataReady = true;
        this.performed = false;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.K = 0.0;
        this.K2 = 0.0;
        int draws = 0;
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (this.sequence.get(i) > 0.0) {
                this.K += 1.0;
            }
            if (this.sequence.get(i) < 0.0) {
                this.K2 += 1.0;
            }
            if (this.sequence.get(i) != 0.0) continue;
            ++draws;
        }
        int effectiveSamples = this.sequence.size() - draws;
        this.binomial.setN(effectiveSamples);
        this.exactLeftTail = this.binomial.computeCumulativeProbability((double)effectiveSamples - this.K2);
        this.exactRightTail = this.binomial.computeCumulativeProbability((double)effectiveSamples - this.K);
        this.exactDoubleTail = Math.min(Math.min(this.exactLeftTail, this.exactRightTail) * 2.0, 1.0);
        double denominator = 0.5 * Math.sqrt(effectiveSamples);
        double numerator = this.K - 0.5 * (double)effectiveSamples + 0.5;
        this.asymptoticLeftTail = this.normal.getTipifiedProbability(numerator / denominator, false);
        numerator = this.K - 0.5 * (double)effectiveSamples - 0.5;
        this.asymptoticRightTail = 1.0 - this.normal.getTipifiedProbability(numerator / denominator, false);
        this.asymptoticDoubleTail = Math.min(Math.min(this.asymptoticLeftTail, this.asymptoticRightTail) * 2.0, 1.0);
        this.performed = true;
    }

    public double getK() {
        return this.K;
    }

    public double getK2() {
        return this.K2;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    public double getLeftPValue() {
        return this.asymptoticLeftTail;
    }

    public double getRightPValue() {
        return this.asymptoticRightTail;
    }

    public double getDoublePValue() {
        return this.asymptoticDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n*******\n";
        report = report + "Sign test\n";
        report = report + "*********\n\n";
        report = report + "K statistic (sample 1): " + this.nf6.format(this.K) + "\n";
        report = report + "K statistic (sample 2): " + this.nf6.format(this.K2) + "\n\n";
        report = report + "Exact P-Value (Left tail, Y > X): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Y < X): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Y != X): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        report = report + "Asymptotic P-Value (Left tail, Y > X): " + this.nf6.format(this.asymptoticLeftTail) + "\n";
        report = report + "Asymptotic P-Value (Right tail, Y > X): " + this.nf6.format(this.asymptoticRightTail) + "\n";
        report = report + "Asymptotic P-Value (Double tail, Y != X): " + this.nf6.format(this.asymptoticDoubleTail) + "\n\n";
        return report;
    }
}

