/*
 * Decompiled with CFR 0.152.
 */
package javanpst.tests.oneSample.populationQuantile;

import javanpst.data.structures.sequence.NumericSequence;
import javanpst.distributions.common.discrete.BinomialDistribution;
import javanpst.tests.StatisticalTest;

public class PopulationQuantile
extends StatisticalTest {
    private BinomialDistribution distribution;
    private NumericSequence sequence;
    private double quantile;
    private double hyphotesisValue;
    private int K;
    private double exactLeftTail;
    private double exactRightTail;
    private double exactDoubleTail;

    public PopulationQuantile() {
        this.setReportFormat();
        this.clearData();
    }

    @Override
    public void clearData() {
        this.K = 0;
        this.quantile = 0.0;
        this.hyphotesisValue = 0.0;
        this.exactLeftTail = -1.0;
        this.exactRightTail = -1.0;
        this.exactDoubleTail = -1.0;
        this.sequence = new NumericSequence();
        this.dataReady = false;
        this.performed = false;
    }

    public PopulationQuantile(NumericSequence newSequence, double quantile, double value) {
        this.setReportFormat();
        this.sequence = new NumericSequence(newSequence);
        this.quantile = quantile;
        this.hyphotesisValue = value;
        this.distribution = new BinomialDistribution();
        this.distribution.setN(this.sequence.size());
        this.distribution.setP(1.0 - quantile);
        this.dataReady = true;
    }

    public void setData(NumericSequence newSequence, double quantile, double value) {
        this.sequence = new NumericSequence(newSequence);
        this.quantile = quantile;
        this.hyphotesisValue = value;
        this.distribution = new BinomialDistribution();
        this.distribution.setN(this.sequence.size());
        this.distribution.setP(1.0 - quantile);
        this.dataReady = true;
    }

    public void setQuantile(double p) {
        this.quantile = p;
    }

    public void setConfidence(double value) {
        this.hyphotesisValue = value;
    }

    @Override
    public void doTest() {
        if (!this.dataReady) {
            System.out.println("Data is not ready");
            return;
        }
        this.K = 0;
        this.sequence.sort();
        for (double d : this.sequence.getSequence()) {
            if (!(d > this.hyphotesisValue)) continue;
            ++this.K;
        }
        this.exactLeftTail = this.distribution.computeCumulativeProbability(this.K);
        this.exactRightTail = 1.0 - this.distribution.computeCumulativeProbability(this.K - 1);
        this.exactDoubleTail = Math.min(this.exactLeftTail, this.exactRightTail) * 2.0;
        this.performed = true;
    }

    public double getK() {
        return this.K;
    }

    public double getExactLeftPValue() {
        return this.exactLeftTail;
    }

    public double getExactRightPValue() {
        return this.exactRightTail;
    }

    public double getExactDoublePValue() {
        return this.exactDoubleTail;
    }

    @Override
    public String printData() {
        String text = "";
        text = text + "\n" + this.sequence;
        return text;
    }

    @Override
    public String printReport() {
        String report = "";
        if (!this.performed) {
            report = report + "The test has not been performed.\n";
            return report;
        }
        report = report + "\n***************************************\n";
        report = report + "Testing a population quantile\n";
        report = report + "***************************************\n\n";
        report = report + "Hypothesis value value: " + this.nf6.format(this.hyphotesisValue) + "\n";
        report = report + "Quantile: " + this.nf6.format(this.quantile) + "\n";
        report = report + "K statistic: " + this.nf6.format(this.K) + "\n\n";
        report = report + "Exact P-Value (Left tail, Kp < Kp0): " + this.nf6.format(this.exactLeftTail) + "\n";
        report = report + "Exact P-Value (Right tail, Kp > Kp0): " + this.nf6.format(this.exactRightTail) + "\n";
        report = report + "Exact P-Value (Double tail, Kp != Kp0): " + this.nf6.format(this.exactDoubleTail) + "\n\n";
        return report;
    }
}

